/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.registration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.util.Assert;

public final class InMemoryClientRegistrationRepository
implements ClientRegistrationRepository,
Iterable<ClientRegistration> {
    private final Map<String, ClientRegistration> registrations;

    public InMemoryClientRegistrationRepository(ClientRegistration ... registrations) {
        Assert.notEmpty((Object[])registrations, (String)"registrations cannot be empty");
        this.registrations = InMemoryClientRegistrationRepository.createClientRegistrationIdToClientRegistration(Arrays.asList(registrations));
    }

    public InMemoryClientRegistrationRepository(List<ClientRegistration> registrations) {
        Assert.notEmpty(registrations, (String)"registrations cannot be empty");
        this.registrations = InMemoryClientRegistrationRepository.createClientRegistrationIdToClientRegistration(registrations);
    }

    private static Map<String, ClientRegistration> createClientRegistrationIdToClientRegistration(Collection<ClientRegistration> registrations) {
        return Collections.unmodifiableMap(registrations.stream().peek(registration -> Assert.notNull((Object)registration, (String)"registrations cannot contain null values")).collect(Collectors.toMap(ClientRegistration::getRegistrationId, Function.identity())));
    }

    @Override
    public ClientRegistration findByRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return this.registrations.get(registrationId);
    }

    @Override
    public Iterator<ClientRegistration> iterator() {
        return this.registrations.values().iterator();
    }
}

