/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.intercept.aspectj;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.CodeSignature;

public final class MethodInvocationAdapter
implements MethodInvocation {
    private final ProceedingJoinPoint jp;
    private final Method method;
    private final Object target;

    MethodInvocationAdapter(JoinPoint jp) {
        this.jp = (ProceedingJoinPoint)jp;
        this.target = jp.getTarget() != null ? jp.getTarget() : jp.getSignature().getDeclaringType();
        String targetMethodName = jp.getStaticPart().getSignature().getName();
        Class[] types = ((CodeSignature)jp.getStaticPart().getSignature()).getParameterTypes();
        Class declaringType = jp.getStaticPart().getSignature().getDeclaringType();
        this.method = this.findMethod(targetMethodName, declaringType, types);
        if (this.method == null) {
            throw new IllegalArgumentException("Could not obtain target method from JoinPoint: '" + jp + "'");
        }
    }

    private Method findMethod(String name, Class<?> declaringType, Class<?>[] params) {
        Method method = null;
        try {
            method = declaringType.getMethod(name, params);
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = declaringType.getDeclaredMethod(name, params);
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
        return method;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArguments() {
        return this.jp.getArgs();
    }

    public AccessibleObject getStaticPart() {
        return this.method;
    }

    public Object getThis() {
        return this.target;
    }

    public Object proceed() throws Throwable {
        return this.jp.proceed();
    }
}

