/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.PostInvocationExpressionAttribute;
import org.springframework.security.access.expression.method.PreInvocationExpressionAttribute;
import org.springframework.security.access.prepost.PostInvocationAttribute;
import org.springframework.security.access.prepost.PreInvocationAttribute;
import org.springframework.security.access.prepost.PrePostInvocationAttributeFactory;

public class ExpressionBasedAnnotationAttributeFactory
implements PrePostInvocationAttributeFactory {
    private final ExpressionParser parser;

    public ExpressionBasedAnnotationAttributeFactory(MethodSecurityExpressionHandler handler) {
        this.parser = handler.getExpressionParser();
    }

    @Override
    public PreInvocationAttribute createPreInvocationAttribute(String preFilterAttribute, String filterObject, String preAuthorizeAttribute) {
        try {
            Expression preAuthorizeExpression = preAuthorizeAttribute == null ? this.parser.parseExpression("permitAll") : this.parser.parseExpression(preAuthorizeAttribute);
            Expression preFilterExpression = preFilterAttribute == null ? null : this.parser.parseExpression(preFilterAttribute);
            return new PreInvocationExpressionAttribute(preFilterExpression, filterObject, preAuthorizeExpression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse expression '" + e.getExpressionString() + "'", e);
        }
    }

    @Override
    public PostInvocationAttribute createPostInvocationAttribute(String postFilterAttribute, String postAuthorizeAttribute) {
        try {
            Expression postFilterExpression;
            Expression postAuthorizeExpression = postAuthorizeAttribute == null ? null : this.parser.parseExpression(postAuthorizeAttribute);
            Expression expression = postFilterExpression = postFilterAttribute == null ? null : this.parser.parseExpression(postFilterAttribute);
            if (postFilterExpression != null || postAuthorizeExpression != null) {
                return new PostInvocationExpressionAttribute(postFilterExpression, postAuthorizeExpression);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse expression '" + e.getExpressionString() + "'", e);
        }
        return null;
    }
}

