/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.integration.support.json.JacksonJsonObjectMapperProvider;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.transformer.AbstractPayloadTransformer;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ObjectToMapTransformer
extends AbstractPayloadTransformer<Object, Map<?, ?>> {
    private final JsonObjectMapper<?, ?> jsonObjectMapper = JacksonJsonObjectMapperProvider.newInstance();
    private volatile boolean shouldFlattenKeys = true;

    public void setShouldFlattenKeys(boolean shouldFlattenKeys) {
        this.shouldFlattenKeys = shouldFlattenKeys;
    }

    @Override
    protected Map<String, Object> transformPayload(Object payload) throws Exception {
        Map<String, Object> result = this.jsonObjectMapper.fromJson((Object)this.jsonObjectMapper.toJson(payload), Map.class);
        if (this.shouldFlattenKeys) {
            result = this.flattenMap(result);
        }
        return result;
    }

    @Override
    public String getComponentType() {
        return "object-to-map-transformer";
    }

    private void doProcessElement(String propertyPrefix, Object element, Map<String, Object> resultMap) {
        if (element instanceof Map) {
            this.doFlatten(propertyPrefix, (Map)element, resultMap);
        } else if (element instanceof Collection) {
            this.doProcessCollection(propertyPrefix, (Collection)element, resultMap);
        } else if (element != null && element.getClass().isArray()) {
            List collection = CollectionUtils.arrayToList((Object)element);
            this.doProcessCollection(propertyPrefix, collection, resultMap);
        } else {
            resultMap.put(propertyPrefix, element);
        }
    }

    private Map<String, Object> flattenMap(Map<String, Object> result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.doFlatten("", result, resultMap);
        return resultMap;
    }

    private void doFlatten(String propertyPrefix, Map<String, Object> inputMap, Map<String, Object> resultMap) {
        if (StringUtils.hasText((String)propertyPrefix)) {
            propertyPrefix = propertyPrefix + ".";
        }
        for (String key : inputMap.keySet()) {
            Object value = inputMap.get(key);
            this.doProcessElement(propertyPrefix + key, value, resultMap);
        }
    }

    private void doProcessCollection(String propertyPrefix, Collection<?> list, Map<String, Object> resultMap) {
        int counter = 0;
        for (Object element : list) {
            this.doProcessElement(propertyPrefix + "[" + counter + "]", element, resultMap);
            ++counter;
        }
    }
}

