/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.integration.transformer.Transformer;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class MessageTransformingHandler
extends AbstractReplyProducingMessageHandler {
    private final Transformer transformer;

    public MessageTransformingHandler(Transformer transformer) {
        Assert.notNull((Object)transformer, (String)"transformer must not be null");
        this.transformer = transformer;
        this.setRequiresReply(true);
    }

    @Override
    public String getComponentType() {
        return this.transformer instanceof NamedComponent ? ((NamedComponent)((Object)this.transformer)).getComponentType() : "transformer";
    }

    @Override
    protected void doInit() {
        if (this.getBeanFactory() != null && this.transformer instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.transformer).setBeanFactory(this.getBeanFactory());
        }
    }

    @Override
    protected Object handleRequestMessage(Message<?> message) {
        try {
            return this.transformer.transform(message);
        }
        catch (Exception e) {
            if (e instanceof MessageTransformationException) {
                throw (MessageTransformationException)((Object)e);
            }
            throw new MessageTransformationException(message, (Throwable)e);
        }
    }

    @Override
    protected boolean shouldCopyRequestHeaders() {
        return false;
    }
}

