/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.transformer.Transformer;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractMessageProcessingTransformer
implements Transformer,
BeanFactoryAware {
    private final MessageProcessor<?> messageProcessor;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();

    protected AbstractMessageProcessingTransformer(MessageProcessor<?> messageProcessor) {
        Assert.notNull(messageProcessor, (String)"messageProcessor must not be null");
        this.messageProcessor = messageProcessor;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        return this.messageBuilderFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        ConversionService conversionService;
        if (this.messageProcessor instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.messageProcessor).setBeanFactory(beanFactory);
        }
        if ((conversionService = IntegrationUtils.getConversionService(beanFactory)) != null && this.messageProcessor instanceof AbstractMessageProcessor) {
            ((AbstractMessageProcessor)this.messageProcessor).setConversionService(conversionService);
        }
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(beanFactory);
    }

    @Override
    public final Message<?> transform(Message<?> message) {
        Object result = this.messageProcessor.processMessage(message);
        if (result == null) {
            return null;
        }
        if (result instanceof Message) {
            return (Message)result;
        }
        return this.messageBuilderFactory.withPayload(result).copyHeaders((Map<String, ?>)message.getHeaders()).build();
    }
}

