/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support;

import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class MutableMessage<T>
implements Message<T>,
Serializable {
    private static final long serialVersionUID = -636635024258737500L;
    private T payload;
    private final MessageHeaders headers;
    private final Map<String, Object> rawHeaders;

    MutableMessage(T payload) {
        this(payload, null);
    }

    MutableMessage(T payload, Map<String, Object> headers) {
        Assert.notNull(payload, (String)"payload must not be null");
        this.headers = new MessageHeaders(headers);
        this.payload = payload;
        this.rawHeaders = (Map)new DirectFieldAccessor((Object)this.headers).getPropertyValue("headers");
        if (headers != null) {
            this.rawHeaders.put("id", headers.get("id"));
            this.rawHeaders.put("timestamp", headers.get("timestamp"));
        }
    }

    public MessageHeaders getHeaders() {
        return this.headers;
    }

    public T getPayload() {
        return this.payload;
    }

    public void setPayload(T payload) {
        Assert.notNull(payload, (String)"'payload' must not be null");
        this.payload = payload;
    }

    public Map<String, Object> getRawHeaders() {
        return this.rawHeaders;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.payload instanceof byte[]) {
            sb.append("[Payload byte[").append(((byte[])this.payload).length).append("]]");
        } else {
            sb.append("[Payload ").append(this.payload.getClass().getSimpleName());
            sb.append(" content=").append(this.payload).append("]");
        }
        sb.append("[Headers=").append(this.headers).append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.headers.hashCode() * 23 + ObjectUtils.nullSafeHashCode(this.payload);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof MutableMessage) {
            MutableMessage other = (MutableMessage)obj;
            return this.headers.getId().equals(other.headers.getId()) && this.headers.equals((Object)other.headers) && this.payload.equals(other.payload);
        }
        return false;
    }
}

