/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.util.IdGenerator;

public class IdGenerators {

    public static class SimpleIncrementingIdGenerator
    implements IdGenerator {
        private final AtomicLong topBits = new AtomicLong();
        private final AtomicLong bottomBits = new AtomicLong();

        public UUID generateId() {
            long bottomBits = this.bottomBits.incrementAndGet();
            if (bottomBits == 0L) {
                this.topBits.incrementAndGet();
            }
            return new UUID(this.topBits.get(), bottomBits);
        }
    }

    public static class JdkIdGenerator
    implements IdGenerator {
        public UUID generateId() {
            return UUID.randomUUID();
        }
    }
}

