/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.store.MessageGroup;
import org.springframework.messaging.Message;

public class SimpleMessageGroup
implements MessageGroup {
    private final Object groupId;
    public final BlockingQueue<Message<?>> messages = new LinkedBlockingQueue();
    private volatile int lastReleasedMessageSequence;
    private final long timestamp;
    private volatile long lastModified;
    private volatile boolean complete;

    public SimpleMessageGroup(Object groupId) {
        this(Collections.emptyList(), groupId, System.currentTimeMillis(), false);
    }

    public SimpleMessageGroup(Collection<? extends Message<?>> messages, Object groupId) {
        this(messages, groupId, System.currentTimeMillis(), false);
    }

    public SimpleMessageGroup(Collection<? extends Message<?>> messages, Object groupId, long timestamp, boolean complete) {
        this.groupId = groupId;
        this.timestamp = timestamp;
        this.complete = complete;
        for (Message<?> message : messages) {
            if (message == null) continue;
            this.addMessage(message);
        }
    }

    public SimpleMessageGroup(MessageGroup messageGroup) {
        this(messageGroup.getMessages(), messageGroup.getGroupId(), messageGroup.getTimestamp(), messageGroup.isComplete());
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public boolean canAdd(Message<?> message) {
        return true;
    }

    public void add(Message<?> message) {
        this.addMessage(message);
    }

    public void remove(Message<?> message) {
        this.messages.remove(message);
    }

    @Override
    public int getLastReleasedMessageSequenceNumber() {
        return this.lastReleasedMessageSequence;
    }

    private boolean addMessage(Message<?> message) {
        return this.messages.offer(message);
    }

    @Override
    public Collection<Message<?>> getMessages() {
        return Collections.unmodifiableCollection(this.messages);
    }

    public void setLastReleasedMessageSequenceNumber(int sequenceNumber) {
        this.lastReleasedMessageSequence = sequenceNumber;
    }

    @Override
    public Object getGroupId() {
        return this.groupId;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void complete() {
        this.complete = true;
    }

    @Override
    public int getSequenceSize() {
        if (this.size() == 0) {
            return 0;
        }
        return new IntegrationMessageHeaderAccessor(this.getOne()).getSequenceSize();
    }

    @Override
    public int size() {
        return this.messages.size();
    }

    @Override
    public Message<?> getOne() {
        Message one = (Message)this.messages.peek();
        return one;
    }

    public void clear() {
        this.messages.clear();
    }

    public String toString() {
        return "SimpleMessageGroup{groupId=" + this.groupId + ", messages=" + this.messages + ", timestamp=" + this.timestamp + ", lastModified=" + this.lastModified + '}';
    }
}

