/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splitter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.util.Function;
import org.springframework.integration.util.FunctionIterator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public abstract class AbstractMessageSplitter
extends AbstractReplyProducingMessageHandler {
    private boolean applySequence = true;

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    @Override
    protected final Object handleRequestMessage(Message<?> message) {
        Iterator<Object> iterator;
        int sequenceSize;
        Object[] items;
        Object result = this.splitMessage(message);
        if (result == null) {
            return null;
        }
        if (result instanceof Collection) {
            items = (Object[])result;
            sequenceSize = items.size();
            iterator = items.iterator();
        } else if (result.getClass().isArray()) {
            items = (Object[])result;
            sequenceSize = items.length;
            iterator = Arrays.asList(items).iterator();
        } else if (result instanceof Iterable) {
            sequenceSize = 0;
            iterator = ((Iterable)result).iterator();
        } else if (result instanceof Iterator) {
            sequenceSize = 0;
            iterator = (Iterator<Object>)result;
        } else {
            sequenceSize = 1;
            iterator = Collections.singleton(result).iterator();
        }
        if (!iterator.hasNext()) {
            return null;
        }
        final MessageHeaders headers = message.getHeaders();
        final UUID correlationId = headers.getId();
        final AtomicInteger sequenceNumber = new AtomicInteger(1);
        return new FunctionIterator(iterator, new Function<Object, AbstractIntegrationMessageBuilder<?>>(){

            @Override
            public AbstractIntegrationMessageBuilder<?> apply(Object object) {
                return AbstractMessageSplitter.this.createBuilder(object, headers, correlationId, sequenceNumber.getAndIncrement(), sequenceSize);
            }
        });
    }

    private AbstractIntegrationMessageBuilder createBuilder(Object item, MessageHeaders headers, Object correlationId, int sequenceNumber, int sequenceSize) {
        AbstractIntegrationMessageBuilder<Object> builder;
        if (item instanceof Message) {
            builder = this.getMessageBuilderFactory().fromMessage((Message)item);
        } else {
            builder = this.getMessageBuilderFactory().withPayload(item);
            builder.copyHeaders((Map<String, ?>)headers);
        }
        if (this.applySequence) {
            builder.pushSequenceDetails(correlationId, sequenceNumber, sequenceSize);
        }
        return builder;
    }

    @Override
    protected void produceReply(Object result, MessageHeaders requestHeaders) {
        Iterator iterator = (Iterator)result;
        while (iterator.hasNext()) {
            super.produceReply(iterator.next(), requestHeaders);
        }
    }

    @Override
    public String getComponentType() {
        return "splitter";
    }

    protected abstract Object splitMessage(Message<?> var1);
}

