/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

class AbstractMessageProcessingRouter
extends AbstractMappingMessageRouter {
    private final MessageProcessor<?> messageProcessor;

    AbstractMessageProcessingRouter(MessageProcessor<?> messageProcessor) {
        Assert.notNull(messageProcessor, (String)"messageProcessor must not be null");
        this.messageProcessor = messageProcessor;
    }

    @Override
    public final void onInit() {
        super.onInit();
        if (this.messageProcessor instanceof AbstractMessageProcessor) {
            ((AbstractMessageProcessor)this.messageProcessor).setConversionService(this.getConversionService());
        }
        if (this.messageProcessor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.messageProcessor).setBeanFactory(this.getBeanFactory());
        }
    }

    @Override
    protected List<Object> getChannelKeys(Message<?> message) {
        Object result = this.messageProcessor.processMessage(message);
        return Collections.singletonList(result);
    }
}

