/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import java.util.Map;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.json.JacksonJsonObjectMapperProvider;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;

public class ObjectToJsonTransformer
extends AbstractTransformer {
    public static final String JSON_CONTENT_TYPE = "application/json";
    private final JsonObjectMapper<?, ?> jsonObjectMapper;
    private final ResultType resultType;
    private volatile String contentType = "application/json";
    private volatile boolean contentTypeExplicitlySet = false;

    public ObjectToJsonTransformer() {
        this(JacksonJsonObjectMapperProvider.newInstance());
    }

    public ObjectToJsonTransformer(JsonObjectMapper<?, ?> jsonObjectMapper) {
        this(jsonObjectMapper, ResultType.STRING);
    }

    public ObjectToJsonTransformer(ResultType resultType) {
        this(JacksonJsonObjectMapperProvider.newInstance(), resultType);
    }

    public ObjectToJsonTransformer(JsonObjectMapper<?, ?> jsonObjectMapper, ResultType resultType) {
        Assert.notNull(jsonObjectMapper, (String)"jsonObjectMapper must not be null");
        Assert.notNull((Object)((Object)resultType), (String)"'resultType' must not be null");
        this.jsonObjectMapper = jsonObjectMapper;
        this.resultType = resultType;
    }

    public void setContentType(String contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.contentTypeExplicitlySet = true;
        this.contentType = contentType.trim();
    }

    @Override
    public String getComponentType() {
        return "object-to-json-transformer";
    }

    @Override
    protected Object doTransform(Message<?> message) throws Exception {
        String payload = ResultType.STRING.equals((Object)this.resultType) ? this.jsonObjectMapper.toJson(message.getPayload()) : this.jsonObjectMapper.toJsonNode(message.getPayload());
        AbstractIntegrationMessageBuilder<String> messageBuilder = this.getMessageBuilderFactory().withPayload(payload);
        LinkedCaseInsensitiveMap headers = new LinkedCaseInsensitiveMap();
        headers.putAll((Map)message.getHeaders());
        if (headers.containsKey((Object)"contentType")) {
            if (this.contentTypeExplicitlySet && StringUtils.hasLength((String)this.contentType)) {
                headers.put("contentType", (Object)this.contentType);
            }
        } else if (StringUtils.hasLength((String)this.contentType)) {
            headers.put("contentType", (Object)this.contentType);
        }
        this.jsonObjectMapper.populateJavaTypes((Map<String, Object>)headers, message.getPayload().getClass());
        messageBuilder.copyHeaders((Map<String, ?>)headers);
        return messageBuilder.build();
    }

    public static enum ResultType {
        STRING,
        NODE;

    }
}

