/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.integration.mapping.support.JsonHeaders;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.json.JacksonJsonObjectMapperProvider;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.messaging.Message;

public class JsonToObjectTransformer
extends AbstractTransformer
implements BeanClassLoaderAware {
    private final Class<?> targetClass;
    private final JsonObjectMapper<?, ?> jsonObjectMapper;

    public JsonToObjectTransformer() {
        this((Class)null);
    }

    public JsonToObjectTransformer(Class<?> targetClass) {
        this(targetClass, null);
    }

    public JsonToObjectTransformer(JsonObjectMapper<?, ?> jsonObjectMapper) {
        this(null, jsonObjectMapper);
    }

    public JsonToObjectTransformer(Class<?> targetClass, JsonObjectMapper<?, ?> jsonObjectMapper) {
        this.targetClass = targetClass;
        this.jsonObjectMapper = jsonObjectMapper != null ? jsonObjectMapper : JacksonJsonObjectMapperProvider.newInstance();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        if (this.jsonObjectMapper instanceof BeanClassLoaderAware) {
            ((BeanClassLoaderAware)this.jsonObjectMapper).setBeanClassLoader(classLoader);
        }
    }

    @Override
    public String getComponentType() {
        return "json-to-object-transformer";
    }

    @Override
    protected Object doTransform(Message<?> message) throws Exception {
        if (this.targetClass != null) {
            return this.jsonObjectMapper.fromJson(message.getPayload(), this.targetClass);
        }
        Object result = this.jsonObjectMapper.fromJson(message.getPayload(), (Map<String, Object>)message.getHeaders());
        AbstractIntegrationMessageBuilder messageBuilder = this.getMessageBuilderFactory().withPayload(result).copyHeaders((Map<String, ?>)message.getHeaders()).removeHeaders(JsonHeaders.HEADERS.toArray(new String[3]));
        return messageBuilder.build();
    }
}

