/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.util.Assert;

public class JsonPropertyAccessor
implements PropertyAccessor {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{String.class, ToStringFriendlyJsonNode.class, ObjectNode.class, ArrayNode.class};
    private ObjectMapper objectMapper = new ObjectMapper();

    public Class<?>[] getSpecificTargetClasses() {
        return SUPPORTED_CLASSES;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        ContainerNode<?> container = this.asJson(target);
        Integer index = this.maybeIndex(name);
        return index != null && container.has(index.intValue()) || container.has(name);
    }

    private ContainerNode<?> assertContainerNode(JsonNode json) throws AccessException {
        if (json instanceof ContainerNode) {
            return (ContainerNode)json;
        }
        throw new AccessException("Can not act on json that is not a ContainerNode: " + json.getClass().getSimpleName());
    }

    private ContainerNode<?> asJson(Object target) throws AccessException {
        if (target instanceof ContainerNode) {
            return (ContainerNode)target;
        }
        if (target instanceof ToStringFriendlyJsonNode) {
            ToStringFriendlyJsonNode wrapper = (ToStringFriendlyJsonNode)target;
            return this.assertContainerNode(wrapper.node);
        }
        if (target instanceof String) {
            try {
                JsonNode json = this.objectMapper.readTree((String)target);
                return this.assertContainerNode(json);
            }
            catch (JsonProcessingException e) {
                throw new AccessException("Exception while trying to deserialize String", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new AccessException("Exception while trying to deserialize String", (Exception)e);
            }
        }
        throw new IllegalStateException("Can't happen. Check SUPPORTED_CLASSES");
    }

    private Integer maybeIndex(String name) {
        try {
            return Integer.valueOf(name);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        ContainerNode<?> container = this.asJson(target);
        Integer index = this.maybeIndex(name);
        if (index != null && container.has(index.intValue())) {
            return new TypedValue((Object)this.wrap(container.get(index.intValue())));
        }
        return new TypedValue((Object)this.wrap(container.get(name)));
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new UnsupportedOperationException("Write is not supported");
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' cannot be null");
        this.objectMapper = objectMapper;
    }

    private ToStringFriendlyJsonNode wrap(JsonNode json) {
        return new ToStringFriendlyJsonNode(json);
    }

    public static class ToStringFriendlyJsonNode {
        private final JsonNode node;

        public ToStringFriendlyJsonNode(JsonNode node) {
            this.node = node;
        }

        public String toString() {
            if (this.node.isValueNode()) {
                return this.node.asText();
            }
            return this.node.toString();
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.node.equals((Object)((ToStringFriendlyJsonNode)o).node);
        }

        public int hashCode() {
            return this.node.toString().hashCode();
        }
    }
}

