/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.advice;

import org.springframework.integration.handler.advice.AbstractRequestHandlerAdvice;
import org.springframework.integration.handler.advice.RetryStateGenerator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryState;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class RequestHandlerRetryAdvice
extends AbstractRequestHandlerAdvice
implements RetryListener {
    private volatile RetryTemplate retryTemplate = new RetryTemplate();
    private volatile RecoveryCallback<Object> recoveryCallback;
    private static final ThreadLocal<Message<?>> messageHolder = new ThreadLocal();
    private volatile RetryStateGenerator retryStateGenerator = new RetryStateGenerator(){

        @Override
        public RetryState determineRetryState(Message<?> message) {
            return null;
        }
    };

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        Assert.notNull((Object)retryTemplate, (String)"'retryTemplate' cannot be null");
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setRetryStateGenerator(RetryStateGenerator retryStateGenerator) {
        Assert.notNull((Object)retryStateGenerator, (String)"'retryStateGenerator' cannot be null");
        this.retryStateGenerator = retryStateGenerator;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        this.retryTemplate.registerListener((RetryListener)this);
    }

    @Override
    protected Object doInvoke(final AbstractRequestHandlerAdvice.ExecutionCallback callback, Object target, Message<?> message) throws Exception {
        RetryState retryState = null;
        retryState = this.retryStateGenerator.determineRetryState(message);
        messageHolder.set(message);
        try {
            Object object = this.retryTemplate.execute((RetryCallback)new RetryCallback<Object, Exception>(){

                public Object doWithRetry(RetryContext context) throws Exception {
                    return callback.cloneAndExecute();
                }
            }, this.recoveryCallback, retryState);
            return object;
        }
        catch (MessagingException e) {
            if (e.getFailedMessage() == null) {
                throw new MessagingException(message, (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException(message, "Failed to invoke handler", (Throwable)this.unwrapExceptionIfNecessary(e));
        }
        finally {
            messageHolder.remove();
        }
    }

    public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
        context.setAttribute("message", messageHolder.get());
        return true;
    }

    public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
    }

    public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
    }
}

