/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.advice;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.util.Assert;

public class ErrorMessageSendingRecoverer
implements RecoveryCallback<Object>,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(ErrorMessageSendingRecoverer.class);
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private BeanFactory beanFactory;

    public ErrorMessageSendingRecoverer(MessageChannel channel) {
        Assert.notNull((Object)channel, (String)"channel cannot be null");
        this.messagingTemplate.setDefaultDestination(channel);
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.messagingTemplate.setBeanFactory(beanFactory);
    }

    public Object recover(RetryContext context) throws Exception {
        Object lastThrowable = context.getLastThrowable();
        if (lastThrowable == null) {
            lastThrowable = new RetryExceptionNotAvailableException((Message)context.getAttribute("message"), "No retry exception available; this can occur, for example, if the RetryPolicy allowed zero attempts to execute the handler; RetryContext: " + context.toString());
        } else if (!(lastThrowable instanceof MessagingException)) {
            lastThrowable = new MessagingException((Message)context.getAttribute("message"), lastThrowable);
        }
        if (logger.isDebugEnabled()) {
            String supplement = ":failedMessage:" + ((MessagingException)((Object)lastThrowable)).getFailedMessage();
            logger.debug((Object)("Sending ErrorMessage " + supplement), lastThrowable);
        }
        this.messagingTemplate.send((Message)new ErrorMessage(lastThrowable));
        return null;
    }

    public static class RetryExceptionNotAvailableException
    extends MessagingException {
        private static final long serialVersionUID = 1L;

        public RetryExceptionNotAvailableException(Message<?> message, String description) {
            super(message, description);
        }
    }
}

