/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.DelayHandlerManagement;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageStore;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@ManagedResource
public class DelayHandler
extends AbstractReplyProducingMessageHandler
implements DelayHandlerManagement,
ApplicationListener<ContextRefreshedEvent> {
    private static final ExpressionParser expressionParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private final String messageGroupId;
    private volatile long defaultDelay;
    private Expression delayExpression;
    private volatile boolean ignoreExpressionFailures = true;
    private volatile String delayHeaderName;
    private volatile MessageGroupStore messageStore;
    private volatile List<Advice> delayedAdviceChain;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private volatile MessageHandler releaseHandler = new ReleaseMessageHandler();
    private EvaluationContext evaluationContext;

    public DelayHandler(String messageGroupId) {
        Assert.notNull((Object)messageGroupId, (String)"'messageGroupId' must not be null");
        this.messageGroupId = messageGroupId;
    }

    public DelayHandler(String messageGroupId, TaskScheduler taskScheduler) {
        this(messageGroupId);
        this.setTaskScheduler(taskScheduler);
    }

    public void setDefaultDelay(long defaultDelay) {
        this.defaultDelay = defaultDelay;
    }

    @Deprecated
    public void setDelayHeaderName(String delayHeaderName) {
        this.delayHeaderName = delayHeaderName;
    }

    public void setDelayExpression(Expression delayExpression) {
        this.delayExpression = delayExpression;
    }

    public void setIgnoreExpressionFailures(boolean ignoreExpressionFailures) {
        this.ignoreExpressionFailures = ignoreExpressionFailures;
    }

    public void setMessageStore(MessageGroupStore messageStore) {
        Assert.state((messageStore != null ? 1 : 0) != 0, (String)"MessageStore must not be null");
        this.messageStore = messageStore;
    }

    public void setDelayedAdviceChain(List<Advice> delayedAdviceChain) {
        Assert.notNull(delayedAdviceChain, (String)"delayedAdviceChain must not be null");
        this.delayedAdviceChain = delayedAdviceChain;
    }

    @Override
    public String getComponentType() {
        return "delayer";
    }

    @Override
    protected void doInit() {
        if (this.messageStore == null) {
            this.messageStore = new SimpleMessageStore();
        } else {
            Assert.isInstanceOf(MessageStore.class, (Object)this.messageStore);
        }
        if (this.delayHeaderName != null) {
            this.logger.warn((Object)"'delayHeaderName' is deprecated in favor of 'delayExpression'");
            if (this.delayExpression == null) {
                this.delayExpression = expressionParser.parseExpression("headers['" + this.delayHeaderName + "']");
            }
        }
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext(this.getBeanFactory());
        this.releaseHandler = this.createReleaseMessageTask();
    }

    private MessageHandler createReleaseMessageTask() {
        ReleaseMessageHandler releaseHandler = new ReleaseMessageHandler();
        if (!CollectionUtils.isEmpty(this.delayedAdviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory((Object)releaseHandler);
            for (Advice advice : this.delayedAdviceChain) {
                proxyFactory.addAdvice(advice);
            }
            return (MessageHandler)proxyFactory.getProxy(ClassUtils.getDefaultClassLoader());
        }
        return releaseHandler;
    }

    @Override
    protected Object handleRequestMessage(Message<?> requestMessage) {
        long delay;
        boolean delayed = requestMessage.getPayload() instanceof DelayedMessageWrapper;
        if (!delayed && (delay = this.determineDelayForMessage(requestMessage)) > 0L) {
            this.releaseMessageAfterDelay(requestMessage, delay);
            return null;
        }
        Object payload = requestMessage.getPayload();
        return delayed ? ((DelayedMessageWrapper)payload).getOriginal().getPayload() : payload;
    }

    private long determineDelayForMessage(Message<?> message) {
        long delay = this.defaultDelay;
        if (this.delayExpression != null) {
            Throwable delayValueException = null;
            Object delayValue = null;
            try {
                delayValue = this.delayExpression.getValue(this.evaluationContext, message);
            }
            catch (EvaluationException e) {
                delayValueException = e;
            }
            if (delayValue instanceof Date) {
                delay = ((Date)delayValue).getTime() - new Date().getTime();
            } else if (delayValue != null) {
                try {
                    delay = Long.valueOf(delayValue.toString());
                }
                catch (NumberFormatException e) {
                    delayValueException = e;
                }
            }
            if (delayValueException != null) {
                if (this.ignoreExpressionFailures) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Failed to get delay value from 'delayExpression': " + delayValueException.getMessage() + ". Will fall back to default delay: " + this.defaultDelay));
                    }
                } else {
                    throw new MessageHandlingException(message, "Error occurred during 'delay' value determination", delayValueException);
                }
            }
        }
        return delay;
    }

    private void releaseMessageAfterDelay(Message<?> message, long delay) {
        Object delayedMessage = message;
        DelayedMessageWrapper messageWrapper = null;
        if (message.getPayload() instanceof DelayedMessageWrapper) {
            messageWrapper = (DelayedMessageWrapper)message.getPayload();
        } else {
            messageWrapper = new DelayedMessageWrapper(message, System.currentTimeMillis());
            delayedMessage = this.getMessageBuilderFactory().withPayload(messageWrapper).copyHeaders((Map<String, ?>)message.getHeaders()).build();
            this.messageStore.addMessageToGroup(this.messageGroupId, (Message<?>)delayedMessage);
        }
        final Message<?> messageToSchedule = delayedMessage;
        this.getTaskScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                DelayHandler.this.releaseMessage(messageToSchedule);
            }
        }, new Date(messageWrapper.getRequestDate() + delay));
    }

    private void releaseMessage(Message<?> message) {
        this.releaseHandler.handleMessage(message);
    }

    private void doReleaseMessage(Message<?> message) {
        if (this.messageStore instanceof SimpleMessageStore || ((MessageStore)((Object)this.messageStore)).removeMessage(message.getHeaders().getId()) != null) {
            this.messageStore.removeMessageFromGroup(this.messageGroupId, message);
            this.handleMessageInternal(message);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No message in the Message Store to release: " + message + ". Likely another instance has already released it."));
        }
    }

    @Override
    public int getDelayedMessageCount() {
        return this.messageStore.messageGroupSize(this.messageGroupId);
    }

    @Override
    public void reschedulePersistedMessages() {
        MessageGroup messageGroup = this.messageStore.getMessageGroup(this.messageGroupId);
        for (final Message<?> message : messageGroup.getMessages()) {
            this.getTaskScheduler().schedule(new Runnable(){

                @Override
                public void run() {
                    long delay = DelayHandler.this.determineDelayForMessage(message);
                    if (delay > 0L) {
                        DelayHandler.this.releaseMessageAfterDelay(message, delay);
                    } else {
                        DelayHandler.this.releaseMessage(message);
                    }
                }
            }, new Date());
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.initialized.getAndSet(true)) {
            this.reschedulePersistedMessages();
        }
    }

    public static final class DelayedMessageWrapper
    implements Serializable {
        private static final long serialVersionUID = -4739802369074947045L;
        private final long requestDate;
        private final Message<?> original;

        DelayedMessageWrapper(Message<?> original, long requestDate) {
            this.original = original;
            this.requestDate = requestDate;
        }

        public long getRequestDate() {
            return this.requestDate;
        }

        public Message<?> getOriginal() {
            return this.original;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelayedMessageWrapper that = (DelayedMessageWrapper)o;
            return this.original.equals(that.original);
        }

        public int hashCode() {
            return this.original.hashCode();
        }
    }

    private class ReleaseMessageHandler
    implements MessageHandler {
        private ReleaseMessageHandler() {
        }

        public void handleMessage(Message<?> message) throws MessagingException {
            DelayHandler.this.doReleaseMessage(message);
        }
    }
}

