/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.ReplyRequiredException;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractReplyProducingMessageHandler
extends AbstractMessageHandler
implements MessageProducer,
BeanClassLoaderAware {
    private MessageChannel outputChannel;
    private String outputChannelName;
    private volatile boolean requiresReply = false;
    private final MessagingTemplate messagingTemplate;
    private volatile RequestHandler advisedRequestHandler;
    private volatile List<Advice> adviceChain;
    private volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public AbstractReplyProducingMessageHandler() {
        this.messagingTemplate = new MessagingTemplate();
    }

    @Override
    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setOutputChannelName(String outputChannelName) {
        this.outputChannelName = outputChannelName;
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    public void setChannelResolver(DestinationResolver<MessageChannel> channelResolver) {
        Assert.notNull(channelResolver, (String)"'channelResolver' must not be null");
        this.messagingTemplate.setDestinationResolver(channelResolver);
    }

    public void setRequiresReply(boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    protected MessagingTemplate getMessagingTemplate() {
        return this.messagingTemplate;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        Assert.notNull(adviceChain, (String)"adviceChain cannot be null");
        this.adviceChain = adviceChain;
    }

    protected boolean hasAdviceChain() {
        return this.adviceChain != null && this.adviceChain.size() > 0;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    protected final void onInit() {
        if (this.getBeanFactory() != null) {
            this.messagingTemplate.setBeanFactory(this.getBeanFactory());
            if (StringUtils.hasText((String)this.outputChannelName)) {
                Assert.isNull((Object)this.outputChannel, (String)"'outputChannelName' and 'outputChannel' are mutually exclusive.");
                try {
                    this.outputChannel = (MessageChannel)this.getBeanFactory().getBean(this.outputChannelName, MessageChannel.class);
                }
                catch (BeansException e) {
                    throw new DestinationResolutionException("Failed to look up MessageChannel with name '" + this.outputChannelName + "' in the BeanFactory.");
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory((Object)new AdvisedRequestHandler());
            for (Advice advice : this.adviceChain) {
                proxyFactory.addAdvice(advice);
            }
            this.advisedRequestHandler = (RequestHandler)proxyFactory.getProxy(this.beanClassLoader);
        }
        this.doInit();
    }

    protected void doInit() {
    }

    @Override
    protected final void handleMessageInternal(Message<?> message) {
        Object result = this.advisedRequestHandler == null ? this.handleRequestMessage(message) : this.doInvokeAdvisedRequestHandler(message);
        if (result != null) {
            MessageHeaders requestHeaders = message.getHeaders();
            this.handleResult(result, requestHeaders);
        } else {
            if (this.requiresReply) {
                throw new ReplyRequiredException(message, "No reply produced by handler '" + this.getComponentName() + "', and its 'requiresReply' property is set to true.");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("handler '" + this + "' produced no reply for request Message: " + message));
            }
        }
    }

    protected Object doInvokeAdvisedRequestHandler(Message<?> message) {
        return this.advisedRequestHandler.handleRequestMessage(message);
    }

    private void handleResult(Object result, MessageHeaders requestHeaders) {
        if (result instanceof Iterable && this.shouldSplitReply((Iterable)result)) {
            for (Object o : (Iterable)result) {
                this.produceReply(o, requestHeaders);
            }
        } else if (result != null) {
            this.produceReply(result, requestHeaders);
        }
    }

    protected void produceReply(Object reply, MessageHeaders requestHeaders) {
        Message<?> replyMessage = this.createReplyMessage(reply, requestHeaders);
        this.sendReplyMessage(replyMessage, requestHeaders.getReplyChannel());
    }

    private Message<?> createReplyMessage(Object reply, MessageHeaders requestHeaders) {
        AbstractIntegrationMessageBuilder<Object> builder = null;
        if (reply instanceof Message) {
            if (!this.shouldCopyRequestHeaders()) {
                return (Message)reply;
            }
            builder = this.getMessageBuilderFactory().fromMessage((Message)reply);
        } else {
            builder = reply instanceof AbstractIntegrationMessageBuilder ? (AbstractIntegrationMessageBuilder<Object>)reply : this.getMessageBuilderFactory().withPayload(reply);
        }
        if (this.shouldCopyRequestHeaders()) {
            builder.copyHeadersIfAbsent((Map<String, ?>)requestHeaders);
        }
        return builder.build();
    }

    private void sendReplyMessage(Message<?> replyMessage, Object replyChannelHeaderValue) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("handler '" + this + "' sending reply Message: " + replyMessage));
        }
        if (this.outputChannel != null) {
            this.sendMessage(replyMessage, this.outputChannel);
        } else if (replyChannelHeaderValue != null) {
            this.sendMessage(replyMessage, replyChannelHeaderValue);
        } else {
            throw new DestinationResolutionException("no output-channel or replyChannel header available");
        }
    }

    private void sendMessage(Message<?> message, Object channel) {
        if (channel instanceof MessageChannel) {
            this.messagingTemplate.send((MessageChannel)channel, message);
        } else if (channel instanceof String) {
            this.messagingTemplate.send((String)channel, message);
        } else {
            throw new MessageDeliveryException(message, "a non-null reply channel value of type MessageChannel or String is required");
        }
    }

    private boolean shouldSplitReply(Iterable<?> reply) {
        for (Object next : reply) {
            if (!(next instanceof Message) && !(next instanceof AbstractIntegrationMessageBuilder)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldCopyRequestHeaders() {
        return true;
    }

    protected abstract Object handleRequestMessage(Message<?> var1);

    private class AdvisedRequestHandler
    implements RequestHandler {
        private AdvisedRequestHandler() {
        }

        @Override
        public Object handleRequestMessage(Message<?> requestMessage) {
            return AbstractReplyProducingMessageHandler.this.handleRequestMessage(requestMessage);
        }

        @Override
        public String toString() {
            return AbstractReplyProducingMessageHandler.this.toString();
        }
    }

    public static interface RequestHandler {
        public Object handleRequestMessage(Message<?> var1);

        public String toString();
    }
}

