/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.context.Lifecycle;
import org.springframework.integration.endpoint.AbstractPollingEndpoint;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.PollableChannel;
import org.springframework.util.Assert;

public class PollingConsumer
extends AbstractPollingEndpoint {
    private final PollableChannel inputChannel;
    private final MessageHandler handler;
    private volatile long receiveTimeout = 1000L;

    public PollingConsumer(PollableChannel inputChannel, MessageHandler handler) {
        Assert.notNull((Object)inputChannel, (String)"inputChannel must not be null");
        Assert.notNull((Object)handler, (String)"handler must not be null");
        this.inputChannel = inputChannel;
        this.handler = handler;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    @Override
    protected void doStart() {
        if (this.handler instanceof Lifecycle) {
            ((Lifecycle)this.handler).start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() {
        if (this.handler instanceof Lifecycle) {
            ((Lifecycle)this.handler).stop();
        }
        super.doStop();
    }

    @Override
    protected void handleMessage(Message<?> message) {
        this.handler.handleMessage(message);
    }

    @Override
    protected Message<?> receiveMessage() {
        Message message = this.receiveTimeout >= 0L ? this.inputChannel.receive(this.receiveTimeout) : this.inputChannel.receive();
        return message;
    }

    @Override
    protected Object getResourceToBind() {
        return this.inputChannel;
    }

    @Override
    protected String getResourceKey() {
        return "inputChannel";
    }
}

