/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;

public abstract class MessageProducerSupport
extends AbstractEndpoint
implements MessageProducer,
TrackableComponent {
    private volatile MessageChannel outputChannel;
    private volatile MessageChannel errorChannel;
    private volatile boolean shouldTrack = false;
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();

    @Override
    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    @Override
    protected void onInit() {
        Assert.notNull((Object)this.outputChannel, (String)"outputChannel is required");
        if (this.getBeanFactory() != null) {
            this.messagingTemplate.setBeanFactory(this.getBeanFactory());
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    protected void sendMessage(Message<?> message) {
        if (message == null) {
            throw new MessagingException("cannot send a null message");
        }
        if (this.shouldTrack) {
            message = MessageHistory.write(message, this, this.getMessageBuilderFactory());
        }
        try {
            this.messagingTemplate.send(this.outputChannel, message);
        }
        catch (Exception e) {
            if (this.errorChannel != null) {
                this.messagingTemplate.send(this.errorChannel, (Message)new ErrorMessage((Throwable)e));
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MessageDeliveryException(message, "failed to send message", (Throwable)e);
        }
    }
}

