/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.scheduling.TaskScheduler;

public abstract class AbstractEndpoint
extends IntegrationObjectSupport
implements SmartLifecycle {
    private volatile boolean autoStartup = true;
    private volatile int phase = 0;
    private volatile boolean running;
    protected final ReentrantLock lifecycleLock = new ReentrantLock();
    protected final Condition lifecycleCondition = this.lifecycleLock.newCondition();

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    @Override
    public void setTaskScheduler(TaskScheduler taskScheduler) {
        super.setTaskScheduler(taskScheduler);
    }

    public final boolean isAutoStartup() {
        return this.autoStartup;
    }

    public final int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.doStart();
                this.running = true;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("started " + this));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.doStop();
                this.running = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("stopped " + this));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected abstract void doStart();

    protected abstract void doStop();
}

