/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.IntegrationRegistrar;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractIntegrationNamespaceHandler
implements NamespaceHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String VERSION = "4.0";
    private final NamespaceHandlerDelegate delegate = new NamespaceHandlerDelegate();

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        this.verifySchemaVersion(element, parserContext);
        new IntegrationRegistrar().registerBeanDefinitions(null, parserContext.getRegistry());
        return this.delegate.parse(element, parserContext);
    }

    public final BeanDefinitionHolder decorate(Node source, BeanDefinitionHolder definition, ParserContext parserContext) {
        return this.delegate.decorate(source, definition, parserContext);
    }

    protected final void registerBeanDefinitionDecorator(String elementName, BeanDefinitionDecorator decorator) {
        this.delegate.doRegisterBeanDefinitionDecorator(elementName, decorator);
    }

    protected final void registerBeanDefinitionDecoratorForAttribute(String attributeName, BeanDefinitionDecorator decorator) {
        this.delegate.doRegisterBeanDefinitionDecoratorForAttribute(attributeName, decorator);
    }

    protected final void registerBeanDefinitionParser(String elementName, BeanDefinitionParser parser) {
        this.delegate.doRegisterBeanDefinitionParser(elementName, parser);
    }

    private void verifySchemaVersion(Element element, ParserContext parserContext) {
        if (!AbstractIntegrationNamespaceHandler.matchesVersion(element) || !AbstractIntegrationNamespaceHandler.matchesVersion(element.getOwnerDocument().getDocumentElement())) {
            parserContext.getReaderContext().error("You cannot use prior versions of Spring Integration schemas with Spring Integration 4.0. Please upgrade your schema declarations or use versionless aliases (e.g. spring-integration.xsd).", (Object)element);
        }
    }

    private static boolean matchesVersion(Element element) {
        String schemaLocation = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        return !StringUtils.hasText((String)schemaLocation) || schemaLocation.matches("(?m).*spring-integration-[a-z-]*4.0.xsd.*") || schemaLocation.matches("(?m).*spring-integration[a-z-]*.xsd.*") || !schemaLocation.matches("(?m).*spring-integration.*");
    }

    private class NamespaceHandlerDelegate
    extends NamespaceHandlerSupport {
        private NamespaceHandlerDelegate() {
        }

        public void init() {
            AbstractIntegrationNamespaceHandler.this.init();
        }

        private void doRegisterBeanDefinitionDecorator(String elementName, BeanDefinitionDecorator decorator) {
            super.registerBeanDefinitionDecorator(elementName, decorator);
        }

        private void doRegisterBeanDefinitionDecoratorForAttribute(String attributeName, BeanDefinitionDecorator decorator) {
            super.registerBeanDefinitionDecoratorForAttribute(attributeName, decorator);
        }

        private void doRegisterBeanDefinitionParser(String elementName, BeanDefinitionParser parser) {
            super.registerBeanDefinitionParser(elementName, parser);
        }
    }
}

