/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.integration.annotation.Aggregator;
import org.springframework.integration.annotation.BridgeFrom;
import org.springframework.integration.annotation.BridgeTo;
import org.springframework.integration.annotation.Filter;
import org.springframework.integration.annotation.InboundChannelAdapter;
import org.springframework.integration.annotation.Router;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.annotation.Splitter;
import org.springframework.integration.annotation.Transformer;
import org.springframework.integration.config.annotation.AggregatorAnnotationPostProcessor;
import org.springframework.integration.config.annotation.BridgeFromAnnotationPostProcessor;
import org.springframework.integration.config.annotation.BridgeToAnnotationPostProcessor;
import org.springframework.integration.config.annotation.FilterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.InboundChannelAdapterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.MessagingAnnotationUtils;
import org.springframework.integration.config.annotation.MethodAnnotationPostProcessor;
import org.springframework.integration.config.annotation.RouterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.ServiceActivatorAnnotationPostProcessor;
import org.springframework.integration.config.annotation.SplitterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.TransformerAnnotationPostProcessor;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MessagingAnnotationPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
InitializingBean,
Lifecycle,
ApplicationListener<ApplicationEvent>,
EnvironmentAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile ConfigurableListableBeanFactory beanFactory;
    private Environment environment;
    private final Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> postProcessors = new HashMap();
    private final Set<ApplicationListener<ApplicationEvent>> listeners = new HashSet<ApplicationListener<ApplicationEvent>>();
    private final Set<Lifecycle> lifecycles = new HashSet<Lifecycle>();
    private volatile boolean running = true;

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.isAssignable(ConfigurableListableBeanFactory.class, beanFactory.getClass(), (String)"a ConfigurableListableBeanFactory is required");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory must not be null");
        this.postProcessors.put(Filter.class, new FilterAnnotationPostProcessor((ListableBeanFactory)this.beanFactory, this.environment));
        this.postProcessors.put(Router.class, new RouterAnnotationPostProcessor((ListableBeanFactory)this.beanFactory, this.environment));
        this.postProcessors.put(Transformer.class, new TransformerAnnotationPostProcessor((ListableBeanFactory)this.beanFactory, this.environment));
        this.postProcessors.put(ServiceActivator.class, new ServiceActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory, this.environment));
        this.postProcessors.put(Splitter.class, new SplitterAnnotationPostProcessor((ListableBeanFactory)this.beanFactory, this.environment));
        this.postProcessors.put(Aggregator.class, new AggregatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory, this.environment));
        this.postProcessors.put(InboundChannelAdapter.class, new InboundChannelAdapterAnnotationPostProcessor((ListableBeanFactory)this.beanFactory, this.environment));
        this.postProcessors.put(BridgeFrom.class, new BridgeFromAnnotationPostProcessor((ListableBeanFactory)this.beanFactory, this.environment));
        this.postProcessors.put(BridgeTo.class, new BridgeToAnnotationPostProcessor((ListableBeanFactory)this.beanFactory, this.environment));
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, final String beanName) throws BeansException {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory must not be null");
        Class<?> beanClass = this.getBeanClass(bean);
        if (AnnotationUtils.findAnnotation(beanClass, Component.class) == null) {
            return bean;
        }
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                HashMap<Class, List> annotationChains = new HashMap<Class, List>();
                for (Class clazz : MessagingAnnotationPostProcessor.this.postProcessors.keySet()) {
                    List annotationChain;
                    if (!AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)clazz.getName()) || (annotationChain = MessagingAnnotationPostProcessor.this.getAnnotationChain(method, clazz)).size() <= 0) continue;
                    annotationChains.put(clazz, annotationChain);
                }
                for (Map.Entry entry : annotationChains.entrySet()) {
                    String phase;
                    Object result;
                    Class annotationType = (Class)entry.getKey();
                    List annotations = (List)entry.getValue();
                    MethodAnnotationPostProcessor postProcessor = (MethodAnnotationPostProcessor)MessagingAnnotationPostProcessor.this.postProcessors.get(annotationType);
                    if (postProcessor == null || !postProcessor.shouldCreateEndpoint(method, annotations) || (result = postProcessor.postProcess(bean, beanName, method, annotations)) == null || !(result instanceof AbstractEndpoint)) continue;
                    AbstractEndpoint endpoint = (AbstractEndpoint)result;
                    String autoStartup = MessagingAnnotationUtils.resolveAttribute(annotations, "autoStartup", String.class);
                    if (StringUtils.hasText((String)autoStartup)) {
                        if (MessagingAnnotationPostProcessor.this.environment != null) {
                            autoStartup = MessagingAnnotationPostProcessor.this.environment.resolvePlaceholders(autoStartup);
                        }
                        if (StringUtils.hasText((String)autoStartup)) {
                            endpoint.setAutoStartup(Boolean.parseBoolean(autoStartup));
                        }
                    }
                    if (StringUtils.hasText((String)(phase = MessagingAnnotationUtils.resolveAttribute(annotations, "phase", String.class)))) {
                        if (MessagingAnnotationPostProcessor.this.environment != null) {
                            phase = MessagingAnnotationPostProcessor.this.environment.resolvePlaceholders(phase);
                        }
                        if (StringUtils.hasText((String)phase)) {
                            endpoint.setPhase(Integer.parseInt(phase));
                        }
                    }
                    String endpointBeanName = MessagingAnnotationPostProcessor.this.generateBeanName(beanName, method, annotationType);
                    endpoint.setBeanName(endpointBeanName);
                    MessagingAnnotationPostProcessor.this.beanFactory.registerSingleton(endpointBeanName, (Object)endpoint);
                    endpoint.setBeanFactory((BeanFactory)MessagingAnnotationPostProcessor.this.beanFactory);
                    try {
                        endpoint.afterPropertiesSet();
                    }
                    catch (Exception e) {
                        throw new BeanInitializationException("failed to initialize annotated component", (Throwable)e);
                    }
                    MessagingAnnotationPostProcessor.this.lifecycles.add(endpoint);
                    if (endpoint.isAutoStartup()) {
                        endpoint.start();
                    }
                    if (!(result instanceof ApplicationListener)) continue;
                    MessagingAnnotationPostProcessor.this.listeners.add((ApplicationListener)result);
                }
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return bean;
    }

    private List<Annotation> getAnnotationChain(Method method, Class<? extends Annotation> annotationType) {
        Annotation[] annotations = AnnotationUtils.getAnnotations((Method)method);
        LinkedList<Annotation> annotationChain = new LinkedList<Annotation>();
        HashSet<Annotation> visited = new HashSet<Annotation>();
        for (Annotation ann : annotations) {
            this.recursiveFindAnnotation(annotationType, ann, annotationChain, visited);
            if (annotationChain.size() <= 0) continue;
            Collections.reverse(annotationChain);
            return annotationChain;
        }
        return annotationChain;
    }

    private boolean recursiveFindAnnotation(Class<? extends Annotation> annotationType, Annotation ann, List<Annotation> annotationChain, Set<Annotation> visited) {
        if (ann.annotationType().equals(annotationType)) {
            annotationChain.add(ann);
            return true;
        }
        for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
            if (ann.equals(metaAnn) || visited.contains(metaAnn) || metaAnn.annotationType().getPackage().getName().startsWith("java.lang")) continue;
            visited.add(metaAnn);
            if (!this.recursiveFindAnnotation(annotationType, metaAnn, annotationChain, visited)) continue;
            annotationChain.add(ann);
            return true;
        }
        return false;
    }

    private Class<?> getBeanClass(Object bean) {
        Class<?> targetClass = AopUtils.getTargetClass((Object)bean);
        return targetClass != null ? targetClass : bean.getClass();
    }

    private String generateBeanName(String originalBeanName, Method method, Class<? extends Annotation> annotationType) {
        String baseName;
        String name = baseName = originalBeanName + "." + method.getName() + "." + ClassUtils.getShortNameAsProperty(annotationType);
        int count = 1;
        while (this.beanFactory.containsBean(name)) {
            name = baseName + "#" + ++count;
        }
        return name;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        for (ApplicationListener<ApplicationEvent> listener : this.listeners) {
            try {
                listener.onApplicationEvent(event);
            }
            catch (ClassCastException e) {
                if (!this.logger.isWarnEnabled() || event == null) continue;
                this.logger.warn((Object)("ApplicationEvent of type [" + event.getClass() + "] not accepted by ApplicationListener [" + listener + "]"));
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        for (Lifecycle lifecycle : this.lifecycles) {
            if (lifecycle.isRunning()) continue;
            lifecycle.start();
        }
        this.running = true;
    }

    public void stop() {
        for (Lifecycle lifecycle : this.lifecycles) {
            if (!lifecycle.isRunning()) continue;
            lifecycle.stop();
        }
        this.running = false;
    }
}

