/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.expression.Expression;
import org.springframework.integration.config.AbstractStandardMessageHandlerFactoryBean;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.transformer.ExpressionEvaluatingTransformer;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.integration.transformer.MethodInvokingTransformer;
import org.springframework.integration.transformer.Transformer;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TransformerFactoryBean
extends AbstractStandardMessageHandlerFactoryBean {
    private volatile Long sendTimeout;

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    @Override
    MessageHandler createMethodInvokingHandler(Object targetObject, String targetMethodName) {
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        Transformer transformer = null;
        if (targetObject instanceof Transformer) {
            transformer = (Transformer)targetObject;
        } else {
            this.checkForIllegalTarget(targetObject, targetMethodName);
            transformer = StringUtils.hasText((String)targetMethodName) ? new MethodInvokingTransformer(targetObject, targetMethodName) : new MethodInvokingTransformer(targetObject);
        }
        return this.createHandler(transformer);
    }

    @Override
    MessageHandler createExpressionEvaluatingHandler(Expression expression) {
        ExpressionEvaluatingTransformer transformer = new ExpressionEvaluatingTransformer(expression);
        return this.createHandler(transformer);
    }

    private MessageTransformingHandler createHandler(Transformer transformer) {
        MessageTransformingHandler handler = new MessageTransformingHandler(transformer);
        this.postProcessReplyProducer(handler);
        return handler;
    }

    @Override
    protected void postProcessReplyProducer(AbstractReplyProducingMessageHandler handler) {
        if (this.sendTimeout != null) {
            handler.setSendTimeout(this.sendTimeout);
        }
    }

    @Override
    protected boolean canBeUsedDirect(AbstractReplyProducingMessageHandler handler) {
        return true;
    }
}

