/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.expression.Expression;
import org.springframework.integration.config.AbstractStandardMessageHandlerFactoryBean;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.StringUtils;

public class ServiceActivatorFactoryBean
extends AbstractStandardMessageHandlerFactoryBean {
    private volatile Long sendTimeout;
    private volatile Boolean requiresReply;

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setRequiresReply(Boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    @Override
    MessageHandler createMethodInvokingHandler(Object targetObject, String targetMethodName) {
        MessageHandler handler = null;
        handler = this.createDirectHandlerIfPossible(targetObject, targetMethodName);
        if (handler == null) {
            handler = this.configureHandler(StringUtils.hasText((String)targetMethodName) ? new ServiceActivatingHandler(targetObject, targetMethodName) : new ServiceActivatingHandler(targetObject));
        }
        return handler;
    }

    private MessageHandler createDirectHandlerIfPossible(final Object targetObject, String targetMethodName) {
        AbstractReplyProducingMessageHandler handler = null;
        if (targetObject instanceof MessageHandler && this.methodIsHandleMessageOrEmpty(targetMethodName)) {
            if (targetObject instanceof AbstractReplyProducingMessageHandler) {
                return (MessageHandler)targetObject;
            }
            handler = new AbstractReplyProducingMessageHandler(){

                @Override
                protected Object handleRequestMessage(Message<?> requestMessage) {
                    ((MessageHandler)targetObject).handleMessage(requestMessage);
                    return null;
                }
            };
        }
        return handler;
    }

    @Override
    MessageHandler createExpressionEvaluatingHandler(Expression expression) {
        ExpressionEvaluatingMessageProcessor processor = new ExpressionEvaluatingMessageProcessor(expression);
        processor.setBeanFactory(this.getBeanFactory());
        return this.configureHandler(new ServiceActivatingHandler(processor));
    }

    @Override
    <T> MessageHandler createMessageProcessingHandler(MessageProcessor<T> processor) {
        return this.configureHandler(new ServiceActivatingHandler(processor));
    }

    private MessageHandler configureHandler(ServiceActivatingHandler handler) {
        this.postProcessReplyProducer(handler);
        return handler;
    }

    @Override
    protected boolean canBeUsedDirect(AbstractReplyProducingMessageHandler handler) {
        return true;
    }

    @Override
    protected void postProcessReplyProducer(AbstractReplyProducingMessageHandler handler) {
        if (this.sendTimeout != null) {
            handler.setSendTimeout(this.sendTimeout);
        }
        if (this.requiresReply != null) {
            handler.setRequiresReply(this.requiresReply);
        }
    }
}

