/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.integration.aop.PublisherAnnotationBeanPostProcessor;
import org.springframework.integration.config.EnablePublisher;
import org.springframework.util.StringUtils;

public class PublisherRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Log logger = LogFactory.getLog(PublisherRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(EnablePublisher.class.getName());
        if (annotationAttributes == null) {
            return;
        }
        String value = (String)annotationAttributes.get("value");
        if (!registry.containsBeanDefinition("org.springframework.integration.internalPublisherAnnotationBeanPostProcessor")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(PublisherAnnotationBeanPostProcessor.class).setRole(2);
            if (StringUtils.hasText((String)value)) {
                builder.addPropertyValue("defaultChannelName", (Object)value);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Setting '@Publisher' default-output-channel to '" + value + "'."));
                }
            }
            registry.registerBeanDefinition("org.springframework.integration.internalPublisherAnnotationBeanPostProcessor", (BeanDefinition)builder.getBeanDefinition());
        } else {
            BeanDefinition beanDefinition = registry.getBeanDefinition("org.springframework.integration.internalPublisherAnnotationBeanPostProcessor");
            MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
            PropertyValue defaultChannelPropertyValue = propertyValues.getPropertyValue("defaultChannelName");
            if (StringUtils.hasText((String)value)) {
                if (defaultChannelPropertyValue == null) {
                    propertyValues.addPropertyValue("defaultChannelName", (Object)value);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Setting '@Publisher' default-output-channel to '" + value + "'."));
                    }
                } else if (!value.equals(defaultChannelPropertyValue.getValue())) {
                    throw new BeanDefinitionStoreException("When more than one enable publisher definition (@EnablePublisher or <annotation-config>) is found in the context, they all must have the same 'default-publisher-channel' value.");
                }
            }
        }
    }
}

