/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.integration.channel.DefaultHeaderChannelRegistry;
import org.springframework.integration.config.ChannelInitializer;
import org.springframework.integration.config.DefaultConfiguringBeanFactoryPostProcessor;
import org.springframework.integration.config.GlobalChannelInterceptorProcessor;
import org.springframework.integration.config.IntegrationConfigUtils;
import org.springframework.integration.config.IntegrationConfigurationBeanFactoryPostProcessor;
import org.springframework.integration.config.IntegrationEvaluationContextFactoryBean;
import org.springframework.integration.config.PublisherRegistrar;
import org.springframework.integration.config.annotation.MessagingAnnotationPostProcessor;
import org.springframework.integration.context.IntegrationProperties;
import org.springframework.integration.expression.IntegrationEvaluationContextAwareBeanPostProcessor;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.converter.DefaultDatatypeChannelMessageConverter;
import org.springframework.util.ClassUtils;

public class IntegrationRegistrar
implements ImportBeanDefinitionRegistrar,
BeanClassLoaderAware {
    private static final Log logger = LogFactory.getLog(IntegrationRegistrar.class);
    private static final Set<Integer> registriesProcessed = new HashSet<Integer>();
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.registerImplicitChannelCreator(registry);
        this.registerIntegrationConfigurationBeanFactoryPostProcessor(registry);
        this.registerIntegrationEvaluationContext(registry);
        this.registerIntegrationProperties(registry);
        this.registerHeaderChannelRegistry(registry);
        this.registerGlobalChannelInterceptorProcessor(registry);
        this.registerBuiltInBeans(registry);
        this.registerDefaultConfiguringBeanFactoryPostProcessor(registry);
        this.registerDefaultDatatypeChannelMessageConverter(registry);
        if (importingClassMetadata != null) {
            this.registerMessagingAnnotationPostProcessors(importingClassMetadata, registry);
        }
        this.registerMessageBuilderFactory(registry);
    }

    private void registerImplicitChannelCreator(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("channelInitializer")) {
            String channelsAutoCreateExpression = IntegrationProperties.getExpressionFor("spring.integraton.channels.autoCreate");
            BeanDefinitionBuilder channelDef = BeanDefinitionBuilder.genericBeanDefinition(ChannelInitializer.class).addPropertyValue("autoCreate", (Object)channelsAutoCreateExpression);
            BeanDefinitionHolder channelCreatorHolder = new BeanDefinitionHolder((BeanDefinition)channelDef.getBeanDefinition(), "channelInitializer");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)channelCreatorHolder, (BeanDefinitionRegistry)registry);
        }
        if (!registry.containsBeanDefinition("$autoCreateChannelCandidates")) {
            BeanDefinitionBuilder channelRegistryBuilder = BeanDefinitionBuilder.genericBeanDefinition(ChannelInitializer.AutoCreateCandidatesCollector.class);
            channelRegistryBuilder.addConstructorArgValue((Object)new ManagedSet());
            BeanDefinitionHolder channelRegistryHolder = new BeanDefinitionHolder((BeanDefinition)channelRegistryBuilder.getBeanDefinition(), "$autoCreateChannelCandidates");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)channelRegistryHolder, (BeanDefinitionRegistry)registry);
        }
    }

    private void registerIntegrationProperties(BeanDefinitionRegistry registry) {
        boolean alreadyRegistered = false;
        alreadyRegistered = registry instanceof ListableBeanFactory ? ((ListableBeanFactory)registry).containsBean("integrationGlobalProperties") : registry.isBeanNameInUse("integrationGlobalProperties");
        if (!alreadyRegistered) {
            PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(this.classLoader);
            try {
                Resource[] defaultResources = resourceResolver.getResources("classpath*:META-INF/spring.integration.default.properties");
                Resource[] userResources = resourceResolver.getResources("classpath*:META-INF/spring.integration.properties");
                LinkedList<Resource> resources = new LinkedList<Resource>(Arrays.asList(defaultResources));
                resources.addAll(Arrays.asList(userResources));
                BeanDefinitionBuilder integrationPropertiesBuilder = BeanDefinitionBuilder.genericBeanDefinition(PropertiesFactoryBean.class).addPropertyValue("locations", resources);
                registry.registerBeanDefinition("integrationGlobalProperties", (BeanDefinition)integrationPropertiesBuilder.getBeanDefinition());
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot load 'spring.integration.properties' Resources.", (Throwable)e);
            }
        }
    }

    private void registerIntegrationEvaluationContext(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("integrationEvaluationContext")) {
            BeanDefinitionBuilder integrationEvaluationContextBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationEvaluationContextFactoryBean.class);
            integrationEvaluationContextBuilder.setRole(2);
            BeanDefinitionHolder integrationEvaluationContextHolder = new BeanDefinitionHolder((BeanDefinition)integrationEvaluationContextBuilder.getBeanDefinition(), "integrationEvaluationContext");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)integrationEvaluationContextHolder, (BeanDefinitionRegistry)registry);
            RootBeanDefinition integrationEvalContextBPP = new RootBeanDefinition(IntegrationEvaluationContextAwareBeanPostProcessor.class);
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)integrationEvalContextBPP, (BeanDefinitionRegistry)registry);
        }
    }

    private void registerBuiltInBeans(BeanDefinitionRegistry registry) {
        int registryId = System.identityHashCode(registry);
        String jsonPathBeanName = "jsonPath";
        boolean alreadyRegistered = false;
        alreadyRegistered = registry instanceof ListableBeanFactory ? ((ListableBeanFactory)registry).containsBean(jsonPathBeanName) : registry.isBeanNameInUse(jsonPathBeanName);
        if (!alreadyRegistered && !registriesProcessed.contains(registryId)) {
            Class jsonPathClass = null;
            try {
                jsonPathClass = ClassUtils.forName((String)"com.jayway.jsonpath.JsonPath", (ClassLoader)this.classLoader);
            }
            catch (ClassNotFoundException e) {
                logger.debug((Object)"SpEL function '#jsonPath' isn't registered: there is no jayway json-path.jar on the classpath.");
            }
            if (jsonPathClass != null) {
                IntegrationConfigUtils.registerSpelFunctionBean(registry, jsonPathBeanName, "org.springframework.integration.json.JsonPathUtils", "evaluate");
            }
        }
        alreadyRegistered = false;
        String xpathBeanName = "xpath";
        alreadyRegistered = registry instanceof ListableBeanFactory ? ((ListableBeanFactory)registry).containsBean(xpathBeanName) : registry.isBeanNameInUse(xpathBeanName);
        if (!alreadyRegistered && !registriesProcessed.contains(registryId)) {
            Class xpathClass = null;
            try {
                xpathClass = ClassUtils.forName((String)"org.springframework.integration.xml.xpath.XPathUtils", (ClassLoader)this.classLoader);
            }
            catch (ClassNotFoundException e) {
                logger.debug((Object)"SpEL function '#xpath' isn't registered: there is no spring-integration-xml.jar on the classpath.");
            }
            if (xpathClass != null) {
                IntegrationConfigUtils.registerSpelFunctionBean(registry, xpathBeanName, "org.springframework.integration.xml.xpath.XPathUtils", "evaluate");
            }
        }
        registriesProcessed.add(registryId);
    }

    private void registerDefaultConfiguringBeanFactoryPostProcessor(BeanDefinitionRegistry registry) {
        boolean alreadyRegistered = false;
        alreadyRegistered = registry instanceof ListableBeanFactory ? ((ListableBeanFactory)registry).containsBean("DefaultConfiguringBeanFactoryPostProcessor") : registry.isBeanNameInUse("DefaultConfiguringBeanFactoryPostProcessor");
        if (!alreadyRegistered) {
            BeanDefinitionBuilder postProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultConfiguringBeanFactoryPostProcessor.class);
            BeanDefinitionHolder postProcessorHolder = new BeanDefinitionHolder((BeanDefinition)postProcessorBuilder.getBeanDefinition(), "DefaultConfiguringBeanFactoryPostProcessor");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)postProcessorHolder, (BeanDefinitionRegistry)registry);
        }
    }

    private void registerHeaderChannelRegistry(BeanDefinitionRegistry registry) {
        boolean alreadyRegistered = false;
        alreadyRegistered = registry instanceof ListableBeanFactory ? ((ListableBeanFactory)registry).containsBean("integrationHeaderChannelRegistry") : registry.isBeanNameInUse("integrationHeaderChannelRegistry");
        if (!alreadyRegistered) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"No bean named 'integrationHeaderChannelRegistry' has been explicitly defined. Therefore, a default DefaultHeaderChannelRegistry will be created.");
            }
            BeanDefinitionBuilder schedulerBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultHeaderChannelRegistry.class);
            BeanDefinitionHolder replyChannelRegistryComponent = new BeanDefinitionHolder((BeanDefinition)schedulerBuilder.getBeanDefinition(), "integrationHeaderChannelRegistry");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)replyChannelRegistryComponent, (BeanDefinitionRegistry)registry);
        }
    }

    private void registerGlobalChannelInterceptorProcessor(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("globalChannelInterceptorProcessor")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GlobalChannelInterceptorProcessor.class).setRole(2);
            registry.registerBeanDefinition("globalChannelInterceptorProcessor", (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private void registerMessagingAnnotationPostProcessors(AnnotationMetadata meta, BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("org.springframework.integration.internalMessagingAnnotationPostProcessor")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MessagingAnnotationPostProcessor.class).setRole(2);
            registry.registerBeanDefinition("org.springframework.integration.internalMessagingAnnotationPostProcessor", (BeanDefinition)builder.getBeanDefinition());
        }
        new PublisherRegistrar().registerBeanDefinitions(meta, registry);
    }

    private void registerIntegrationConfigurationBeanFactoryPostProcessor(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("IntegrationConfigurationBeanFactoryPostProcessor")) {
            BeanDefinitionBuilder postProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationConfigurationBeanFactoryPostProcessor.class).setRole(2);
            registry.registerBeanDefinition("IntegrationConfigurationBeanFactoryPostProcessor", (BeanDefinition)postProcessorBuilder.getBeanDefinition());
        }
    }

    private void registerDefaultDatatypeChannelMessageConverter(BeanDefinitionRegistry registry) {
        boolean alreadyRegistered = false;
        alreadyRegistered = registry instanceof ListableBeanFactory ? ((ListableBeanFactory)registry).containsBean("datatypeChannelMessageConverter") : registry.isBeanNameInUse("datatypeChannelMessageConverter");
        if (!alreadyRegistered) {
            BeanDefinitionBuilder converterBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultDatatypeChannelMessageConverter.class);
            registry.registerBeanDefinition("datatypeChannelMessageConverter", (BeanDefinition)converterBuilder.getBeanDefinition());
        }
    }

    private void registerMessageBuilderFactory(BeanDefinitionRegistry registry) {
        boolean alreadyRegistered = false;
        alreadyRegistered = registry instanceof ListableBeanFactory ? ((ListableBeanFactory)registry).containsBean("messageBuilderFactory") : registry.isBeanNameInUse("messageBuilderFactory");
        if (!alreadyRegistered) {
            BeanDefinitionBuilder mbfBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultMessageBuilderFactory.class);
            registry.registerBeanDefinition("messageBuilderFactory", (BeanDefinition)mbfBuilder.getBeanDefinition());
        }
    }
}

