/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.HashSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class IntegrationConfigurationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashSet initializerNames = new HashSet(SpringFactoriesLoader.loadFactoryNames(IntegrationConfigurationInitializer.class, (ClassLoader)beanFactory.getBeanClassLoader()));
        for (String initializerName : initializerNames) {
            try {
                Class instanceClass = ClassUtils.forName((String)initializerName, (ClassLoader)beanFactory.getBeanClassLoader());
                Assert.isAssignable(IntegrationConfigurationInitializer.class, (Class)instanceClass);
                IntegrationConfigurationInitializer instance = (IntegrationConfigurationInitializer)instanceClass.newInstance();
                instance.initialize(beanFactory);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot instantiate 'IntegrationConfigurationInitializer': " + initializerName, e);
            }
        }
    }
}

