/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.List;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.context.Orderable;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class AbstractSimpleMessageHandlerFactoryBean<H extends MessageHandler>
implements FactoryBean<MessageHandler>,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile H handler;
    private volatile MessageChannel outputChannel;
    private volatile Integer order;
    private BeanFactory beanFactory;
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();
    private volatile List<Advice> adviceChain;
    private volatile String componentName;

    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public H getObject() throws Exception {
        if (this.handler == null) {
            this.handler = this.createHandlerInternal();
            Assert.notNull(this.handler, (String)"failed to create MessageHandler");
        }
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final H createHandlerInternal() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return null;
            }
            this.handler = this.createHandler();
            if (this.handler instanceof BeanFactoryAware) {
                ((BeanFactoryAware)this.handler).setBeanFactory(this.getBeanFactory());
            }
            if (this.handler instanceof MessageProducer && this.outputChannel != null) {
                ((MessageProducer)this.handler).setOutputChannel(this.outputChannel);
            }
            if (this.handler instanceof IntegrationObjectSupport && this.componentName != null) {
                ((IntegrationObjectSupport)this.handler).setComponentName(this.componentName);
            }
            if (!CollectionUtils.isEmpty(this.adviceChain) && this.handler instanceof AbstractReplyProducingMessageHandler) {
                ((AbstractReplyProducingMessageHandler)this.handler).setAdviceChain(this.adviceChain);
            }
            if (this.handler instanceof Orderable && this.order != null) {
                ((Orderable)this.handler).setOrder(this.order);
            }
            this.initialized = true;
        }
        if (this.handler instanceof InitializingBean) {
            try {
                ((InitializingBean)this.handler).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new BeanInitializationException("failed to initialize MessageHandler", (Throwable)e);
            }
        }
        return this.handler;
    }

    protected abstract H createHandler();

    public Class<? extends MessageHandler> getObjectType() {
        if (this.handler != null) {
            return this.handler.getClass();
        }
        return MessageHandler.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

