/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.concurrent.Executor;
import org.springframework.integration.channel.AbstractSubscribableChannel;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.dispatcher.BroadcastingDispatcher;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.util.ErrorHandlingTaskExecutor;
import org.springframework.util.ErrorHandler;

public class PublishSubscribeChannel
extends AbstractSubscribableChannel {
    private volatile BroadcastingDispatcher dispatcher;
    private volatile Executor executor;
    private volatile ErrorHandler errorHandler;
    private volatile boolean ignoreFailures;
    private volatile boolean applySequence;
    private volatile int minSubscribers;
    private volatile Integer maxSubscribers;

    @Override
    public String getComponentType() {
        return "publish-subscribe-channel";
    }

    public PublishSubscribeChannel(Executor executor) {
        this.executor = executor;
        this.dispatcher = new BroadcastingDispatcher(executor);
    }

    public PublishSubscribeChannel() {
        this(null);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
        this.getDispatcher().setIgnoreFailures(ignoreFailures);
    }

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
        this.getDispatcher().setApplySequence(applySequence);
    }

    public void setMaxSubscribers(int maxSubscribers) {
        this.maxSubscribers = maxSubscribers;
        this.getDispatcher().setMaxSubscribers(maxSubscribers);
    }

    public void setMinSubscribers(int minSubscribers) {
        this.minSubscribers = minSubscribers;
        this.getDispatcher().setMinSubscribers(minSubscribers);
    }

    @Override
    public final void onInit() {
        if (this.executor != null) {
            if (!(this.executor instanceof ErrorHandlingTaskExecutor)) {
                if (this.errorHandler == null) {
                    this.errorHandler = new MessagePublishingErrorHandler(new BeanFactoryChannelResolver(this.getBeanFactory()));
                }
                this.executor = new ErrorHandlingTaskExecutor(this.executor, this.errorHandler);
            }
            this.dispatcher = new BroadcastingDispatcher(this.executor);
            this.dispatcher.setIgnoreFailures(this.ignoreFailures);
            this.dispatcher.setApplySequence(this.applySequence);
            this.dispatcher.setMinSubscribers(this.minSubscribers);
        }
        if (this.maxSubscribers == null) {
            Integer maxSubscribers = this.getIntegrationProperty("spring.integraton.channels.maxBroadcastSubscribers", Integer.class);
            this.setMaxSubscribers(maxSubscribers);
        }
        this.dispatcher.setBeanFactory(this.getBeanFactory());
    }

    @Override
    protected BroadcastingDispatcher getDispatcher() {
        return this.dispatcher;
    }
}

