/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.core.OrderComparator;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.channel.ChannelInterceptorAware;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractMessageChannel
extends IntegrationObjectSupport
implements MessageChannel,
TrackableComponent,
ChannelInterceptorAware {
    private final ChannelInterceptorList interceptors = new ChannelInterceptorList();
    private final Comparator<Object> orderComparator = new OrderComparator();
    private volatile boolean shouldTrack = false;
    private volatile Class<?>[] datatypes = new Class[0];
    private volatile String fullChannelName;
    private volatile MessageConverter messageConverter;

    @Override
    public String getComponentType() {
        return "channel";
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    public void setDatatypes(Class<?> ... datatypes) {
        this.datatypes = datatypes != null && datatypes.length > 0 ? datatypes : new Class[]{};
    }

    @Override
    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        Collections.sort(interceptors, this.orderComparator);
        this.interceptors.set(interceptors);
    }

    @Override
    public void addInterceptor(ChannelInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public void addInterceptor(int index, ChannelInterceptor interceptor) {
        this.interceptors.add(index, interceptor);
    }

    @Override
    @Deprecated
    public void setConversionService(ConversionService conversionService) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"The conversion service is no longer used; see setMessageConverter()");
        }
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Override
    public List<ChannelInterceptor> getChannelInterceptors() {
        return this.interceptors.getInterceptors();
    }

    protected ChannelInterceptorList getInterceptors() {
        return this.interceptors;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        if (this.messageConverter == null && this.getBeanFactory() != null && this.getBeanFactory().containsBean("datatypeChannelMessageConverter")) {
            this.messageConverter = (MessageConverter)this.getBeanFactory().getBean("datatypeChannelMessageConverter", MessageConverter.class);
        }
    }

    public String getFullChannelName() {
        if (this.fullChannelName == null) {
            String contextId = this.getApplicationContextId();
            String componentName = this.getComponentName();
            this.fullChannelName = componentName = (StringUtils.hasText((String)contextId) ? contextId + "." : "") + (StringUtils.hasText((String)componentName) ? componentName : "unknown.channel.name");
        }
        return this.fullChannelName;
    }

    public final boolean send(Message<?> message) {
        return this.send(message, -1L);
    }

    public final boolean send(Message<?> message, long timeout) {
        Assert.notNull(message, (String)"message must not be null");
        Assert.notNull((Object)message.getPayload(), (String)"message payload must not be null");
        if (this.shouldTrack) {
            message = MessageHistory.write(message, this, this.getMessageBuilderFactory());
        }
        try {
            if (this.datatypes.length > 0) {
                message = this.convertPayloadIfNecessary(message);
            }
            if ((message = this.interceptors.preSend(message, this)) == null) {
                return false;
            }
            boolean sent = this.doSend(message, timeout);
            this.interceptors.postSend(message, this, sent);
            return sent;
        }
        catch (Exception e) {
            if (e instanceof MessagingException) {
                throw (MessagingException)((Object)e);
            }
            throw new MessageDeliveryException(message, "failed to send Message to channel '" + this.getComponentName() + "'", (Throwable)e);
        }
    }

    private Message<?> convertPayloadIfNecessary(Message<?> message) {
        for (Class<?> datatype : this.datatypes) {
            if (!datatype.isAssignableFrom(message.getPayload().getClass())) continue;
            return message;
        }
        if (this.messageConverter != null) {
            for (Class<?> datatype : this.datatypes) {
                Object converted = this.messageConverter.fromMessage(message, datatype);
                if (converted == null) continue;
                if (converted instanceof Message) {
                    return (Message)converted;
                }
                return this.getMessageBuilderFactory().withPayload(converted).copyHeaders((Map<String, ?>)message.getHeaders()).build();
            }
        }
        throw new MessageDeliveryException(message, "Channel '" + this.getComponentName() + "' expected one of the following datataypes [" + StringUtils.arrayToCommaDelimitedString((Object[])this.datatypes) + "], but received [" + message.getPayload().getClass() + "]");
    }

    protected abstract boolean doSend(Message<?> var1, long var2);

    protected class ChannelInterceptorList {
        private final List<ChannelInterceptor> interceptors = new CopyOnWriteArrayList<ChannelInterceptor>();

        protected ChannelInterceptorList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean set(List<ChannelInterceptor> interceptors) {
            List<ChannelInterceptor> list = this.interceptors;
            synchronized (list) {
                this.interceptors.clear();
                return this.interceptors.addAll(interceptors);
            }
        }

        public boolean add(ChannelInterceptor interceptor) {
            return this.interceptors.add(interceptor);
        }

        public void add(int index, ChannelInterceptor interceptor) {
            this.interceptors.add(index, interceptor);
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            if (AbstractMessageChannel.this.logger.isDebugEnabled()) {
                AbstractMessageChannel.this.logger.debug((Object)("preSend on channel '" + channel + "', message: " + message));
            }
            if (this.interceptors.size() > 0) {
                for (ChannelInterceptor interceptor : this.interceptors) {
                    message = interceptor.preSend(message, channel);
                    if (message != null) continue;
                    return null;
                }
            }
            return message;
        }

        public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
            if (AbstractMessageChannel.this.logger.isDebugEnabled()) {
                AbstractMessageChannel.this.logger.debug((Object)("postSend (sent=" + sent + ") on channel '" + channel + "', message: " + message));
            }
            if (this.interceptors.size() > 0) {
                for (ChannelInterceptor interceptor : this.interceptors) {
                    interceptor.postSend(message, channel, sent);
                }
            }
        }

        public boolean preReceive(MessageChannel channel) {
            if (AbstractMessageChannel.this.logger.isTraceEnabled()) {
                AbstractMessageChannel.this.logger.trace((Object)("preReceive on channel '" + channel + "'"));
            }
            if (this.interceptors.size() > 0) {
                for (ChannelInterceptor interceptor : this.interceptors) {
                    if (interceptor.preReceive(channel)) continue;
                    return false;
                }
            }
            return true;
        }

        public Message<?> postReceive(Message<?> message, MessageChannel channel) {
            if (message != null && AbstractMessageChannel.this.logger.isDebugEnabled()) {
                AbstractMessageChannel.this.logger.debug((Object)("postReceive on channel '" + channel + "', message: " + message));
            } else if (AbstractMessageChannel.this.logger.isTraceEnabled()) {
                AbstractMessageChannel.this.logger.trace((Object)("postReceive on channel '" + channel + "', message is null"));
            }
            if (this.interceptors.size() > 0) {
                for (ChannelInterceptor interceptor : this.interceptors) {
                    message = interceptor.postReceive(message, channel);
                    if (message != null) continue;
                    return null;
                }
            }
            return message;
        }

        public List<ChannelInterceptor> getInterceptors() {
            return Collections.unmodifiableList(this.interceptors);
        }
    }
}

