/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.annotation.Header;
import org.springframework.integration.annotation.Payload;
import org.springframework.integration.annotation.Publisher;
import org.springframework.integration.aop.PublisherMetadataSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MethodAnnotationPublisherMetadataSource
implements PublisherMetadataSource {
    private final Set<Class<? extends Annotation>> annotationTypes;
    private volatile String channelAttributeName = "channel";
    private final ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();

    public MethodAnnotationPublisherMetadataSource() {
        this(Collections.singleton(Publisher.class));
    }

    public MethodAnnotationPublisherMetadataSource(Set<Class<? extends Annotation>> annotationTypes) {
        Assert.notEmpty(annotationTypes, (String)"annotationTypes must not be empty");
        this.annotationTypes = annotationTypes;
    }

    public void setChannelAttributeName(String channelAttributeName) {
        Assert.hasText((String)channelAttributeName, (String)"channelAttributeName must not be empty");
        this.channelAttributeName = channelAttributeName;
    }

    @Override
    public String getChannelName(Method method) {
        String channelName = this.getAnnotationValue(method, this.channelAttributeName, String.class);
        if (channelName == null) {
            channelName = this.getAnnotationValue(method.getDeclaringClass(), this.channelAttributeName, String.class);
        }
        return StringUtils.hasText((String)channelName) ? channelName : null;
    }

    @Override
    public String getPayloadExpression(Method method) {
        String payloadExpression = null;
        Payload methodPayloadAnnotation = (Payload)AnnotationUtils.findAnnotation((Method)method, Payload.class);
        if (methodPayloadAnnotation != null) {
            payloadExpression = StringUtils.hasText((String)methodPayloadAnnotation.value()) ? methodPayloadAnnotation.value() : "#return";
        }
        Annotation[][] annotationArray = method.getParameterAnnotations();
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation currentAnnotation : parameterAnnotations = annotationArray[i]) {
                if (!Payload.class.equals(currentAnnotation.annotationType())) continue;
                Assert.state((payloadExpression == null ? 1 : 0) != 0, (String)"@Payload can be used at most once on a @Publisher method, either at method-level or on a single parameter");
                Assert.state((boolean)"".equals(((Payload)currentAnnotation).value()), (String)"@Payload on a parameter for a @Publisher method may not contain an expression");
                payloadExpression = "#args[" + i + "]";
            }
        }
        if (payloadExpression == null || payloadExpression.contains("#return")) {
            Assert.isTrue((!Void.TYPE.equals(method.getReturnType()) ? 1 : 0) != 0, (String)"When defining @Publisher on a void-returning method, an explicit payload expression that does not rely upon a #return value is required.");
        }
        return payloadExpression;
    }

    @Override
    public Map<String, String> getHeaderExpressions(Method method) {
        HashMap<String, String> headerExpressions = new HashMap<String, String>();
        String[] parameterNames = this.parameterNameDiscoverer.getParameterNames(method);
        Annotation[][] annotationArray = method.getParameterAnnotations();
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation currentAnnotation : parameterAnnotations = annotationArray[i]) {
                if (!Header.class.equals(currentAnnotation.annotationType())) continue;
                Header headerAnnotation = (Header)currentAnnotation;
                String name = headerAnnotation.value();
                if (!StringUtils.hasText((String)name)) {
                    name = parameterNames[i];
                }
                headerExpressions.put(name, "#args[" + i + "]");
            }
        }
        return headerExpressions;
    }

    private <T> T getAnnotationValue(Method method, String attributeName, Class<T> expectedType) {
        T value = null;
        for (Class<? extends Annotation> annotationType : this.annotationTypes) {
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, annotationType);
            if (annotation == null) continue;
            if (value != null) {
                throw new IllegalStateException("method [" + method + "] contains more than one publisher annotation");
            }
            value = this.getAnnotationValue(annotation, attributeName, expectedType);
        }
        return value;
    }

    private <T> T getAnnotationValue(Class<?> clazz, String attributeName, Class<T> expectedType) {
        T value = null;
        for (Class<? extends Annotation> annotationType : this.annotationTypes) {
            Annotation annotation = AnnotationUtils.findAnnotation(clazz, annotationType);
            if (annotation == null) continue;
            if (value != null) {
                throw new IllegalStateException("class [" + clazz + "] contains more than one publisher annotation");
            }
            value = this.getAnnotationValue(annotation, attributeName, expectedType);
        }
        return value;
    }

    private <T> T getAnnotationValue(Annotation annotation, String attributeName, Class<T> expectedType) {
        Object valueAsObject;
        Object value = null;
        Object object = valueAsObject = attributeName == null ? AnnotationUtils.getValue((Annotation)annotation) : AnnotationUtils.getValue((Annotation)annotation, (String)attributeName);
        if (valueAsObject != null) {
            if (expectedType.isAssignableFrom(valueAsObject.getClass())) {
                value = valueAsObject;
            } else {
                throw new IllegalArgumentException("expected type [" + expectedType.getName() + "] for attribute '" + attributeName + "' on publisher annotation [" + annotation.annotationType() + "], but actual type was [" + valueAsObject.getClass() + "]");
            }
        }
        return (T)value;
    }
}

