/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.aop.PublisherMetadataSource;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MessagePublishingInterceptor
implements MethodInterceptor,
BeanFactoryAware {
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private volatile PublisherMetadataSource metadataSource;
    private final ExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private volatile DestinationResolver<MessageChannel> channelResolver;
    private volatile BeanFactory beanFactory;
    private final ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile String defaultChannelName;

    public MessagePublishingInterceptor(PublisherMetadataSource metadataSource) {
        Assert.notNull((Object)metadataSource, (String)"metadataSource must not be null");
        this.metadataSource = metadataSource;
    }

    public void setPublisherMetadataSource(PublisherMetadataSource metadataSource) {
        Assert.notNull((Object)metadataSource, (String)"metadataSource must not be null");
        this.metadataSource = metadataSource;
    }

    @Deprecated
    public void setDefaultChannel(MessageChannel defaultChannel) {
        this.messagingTemplate.setDefaultDestination(defaultChannel);
        this.defaultChannelName = null;
    }

    public void setDefaultChannelName(String defaultChannelName) {
        this.defaultChannelName = defaultChannelName;
    }

    public void setChannelResolver(DestinationResolver<MessageChannel> channelResolver) {
        this.channelResolver = channelResolver;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.messagingTemplate.setBeanFactory(beanFactory);
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(beanFactory);
    }

    public final Object invoke(MethodInvocation invocation) throws Throwable {
        Assert.notNull((Object)this.metadataSource, (String)"PublisherMetadataSource is required.");
        StandardEvaluationContext context = ExpressionUtils.createStandardEvaluationContext(this.beanFactory);
        Class targetClass = AopUtils.getTargetClass((Object)invocation.getThis());
        Method method = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), (Class)targetClass);
        String[] argumentNames = this.resolveArgumentNames(method);
        context.setVariable("method", (Object)method.getName());
        if (invocation.getArguments().length > 0 && argumentNames != null) {
            HashMap<Object, Object> argumentMap = new HashMap<Object, Object>();
            for (int i = 0; i < argumentNames.length && invocation.getArguments().length > i; ++i) {
                Object argValue = invocation.getArguments()[i];
                argumentMap.put(i, argValue);
                argumentMap.put(argumentNames[i], argValue);
            }
            context.setVariable("args", argumentMap);
        }
        try {
            Object returnValue = invocation.proceed();
            context.setVariable("return", returnValue);
            Object object = returnValue;
            return object;
        }
        catch (Throwable t) {
            context.setVariable("exception", (Object)t);
            throw t;
        }
        finally {
            this.publishMessage(method, context);
        }
    }

    private String[] resolveArgumentNames(Method method) {
        return this.parameterNameDiscoverer.getParameterNames(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishMessage(Method method, StandardEvaluationContext context) throws Exception {
        Expression expression;
        Object result;
        String payloadExpressionString = this.metadataSource.getPayloadExpression(method);
        if (!StringUtils.hasText((String)payloadExpressionString)) {
            payloadExpressionString = "#return";
        }
        if ((result = (expression = this.parser.parseExpression(payloadExpressionString)).getValue((EvaluationContext)context)) != null) {
            AbstractIntegrationMessageBuilder<Object> builder = result instanceof Message ? this.messageBuilderFactory.fromMessage((Message)result) : this.messageBuilderFactory.withPayload(result);
            Map<String, Object> headers = this.evaluateHeaders(method, context);
            if (headers != null) {
                builder.copyHeaders(headers);
            }
            Message<Object> message = builder.build();
            String channelName = this.metadataSource.getChannelName(method);
            MessageChannel channel = null;
            if (channelName != null) {
                Assert.state((this.channelResolver != null ? 1 : 0) != 0, (String)"ChannelResolver is required to resolve channel names.");
                channel = (MessageChannel)this.channelResolver.resolveDestination(channelName);
            }
            if (channel != null) {
                this.messagingTemplate.send(channel, message);
            } else {
                if (this.defaultChannelName != null) {
                    MessagePublishingInterceptor messagePublishingInterceptor = this;
                    synchronized (messagePublishingInterceptor) {
                        if (this.defaultChannelName != null && this.messagingTemplate.getDefaultDestination() == null) {
                            Assert.state((this.channelResolver != null ? 1 : 0) != 0, (String)"ChannelResolver is required to resolve channel names.");
                            this.messagingTemplate.setDefaultChannel((MessageChannel)this.channelResolver.resolveDestination(this.defaultChannelName));
                        }
                        this.defaultChannelName = null;
                    }
                }
                this.messagingTemplate.send(message);
            }
        }
    }

    private Map<String, Object> evaluateHeaders(Method method, StandardEvaluationContext context) throws ParseException, EvaluationException {
        Map<String, String> headerExpressionMap = this.metadataSource.getHeaderExpressions(method);
        if (headerExpressionMap != null) {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            for (Map.Entry<String, String> headerExpressionEntry : headerExpressionMap.entrySet()) {
                Expression expression;
                Object result;
                String headerExpression = headerExpressionEntry.getValue();
                if (!StringUtils.hasText((String)headerExpression) || (result = (expression = this.parser.parseExpression(headerExpression)).getValue((EvaluationContext)context)) == null) continue;
                headers.put(headerExpressionEntry.getKey(), result);
            }
            if (headers.size() > 0) {
                return headers;
            }
        }
        return null;
    }
}

