/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.data.solr.server.support.SolrClientFactoryBase;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HttpSolrClientFactory
extends SolrClientFactoryBase {
    @Nullable
    private Credentials credentials;
    @Nullable
    private String authPolicy;

    protected HttpSolrClientFactory() {
    }

    public HttpSolrClientFactory(SolrClient solrClient) {
        this(solrClient, null, null);
    }

    public HttpSolrClientFactory(SolrClient solrClient, @Nullable Credentials credentials, @Nullable String authPolicy) {
        super(solrClient);
        Assert.notNull((Object)solrClient, (String)"SolrServer must not be null");
        if (authPolicy != null) {
            Assert.hasText((String)authPolicy, (String)"AuthPolicy must not be null nor empty!");
        }
        this.credentials = credentials;
        this.authPolicy = authPolicy;
        this.appendAuthentication(this.credentials, this.authPolicy, this.getSolrClient());
    }

    private void appendAuthentication(Credentials credentials, String authPolicy, SolrClient solrClient) {
        if (this.isHttpSolrClient(solrClient)) {
            HttpSolrClient httpSolrClient = (HttpSolrClient)solrClient;
            if (credentials != null && StringUtils.isNotBlank((CharSequence)authPolicy) && this.assertHttpClientInstance(httpSolrClient.getHttpClient())) {
                AbstractHttpClient httpClient = (AbstractHttpClient)httpSolrClient.getHttpClient();
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY), credentials);
                httpClient.getParams().setParameter("http.auth.target-scheme-pref", Collections.singletonList(authPolicy));
            }
        }
    }

    private boolean assertHttpClientInstance(HttpClient httpClient) {
        Assert.isInstanceOf(AbstractHttpClient.class, (Object)httpClient, (String)"HttpClient has to be derivate of AbstractHttpClient in order to allow authentication.");
        return true;
    }
}

