/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryUtils {
    public static final String COUNT_QUERY_STRING = "select count(%s) from %s x";
    public static final String EXISTS_QUERY_STRING = "select count(%s) from %s x where x.%s = :id";
    public static final String DELETE_ALL_QUERY_STRING = "delete from %s x";
    public static final String READ_ALL_QUERY = "select x from %s x";
    private static final String DEFAULT_ALIAS = "x";
    private static final String COUNT_REPLACEMENT = "select count($3$5) $4$5$6";
    private static final Pattern ALIAS_MATCH;
    private static final Pattern COUNT_MATCH;
    private static final String IDENTIFIER = "[\\p{Alnum}._$]+";
    private static final String IDENTIFIER_GROUP;

    private QueryUtils() {
    }

    public static String getQueryString(String template, String entityName) {
        Assert.hasText((String)entityName, (String)"Entity name must not be null or empty!");
        return String.format(template, entityName);
    }

    public static String applySorting(String query, Sort sort) {
        return QueryUtils.applySorting(query, sort, DEFAULT_ALIAS);
    }

    public static String applySorting(String query, Sort sort, String alias) {
        Assert.hasText((String)query);
        if (null == sort) {
            return query;
        }
        StringBuilder builder = new StringBuilder(query);
        builder.append(" order by");
        for (Sort.Order order : sort) {
            builder.append(String.format(" %s.%s %s,", alias, order.getProperty(), QueryUtils.toJpaDirection(order)));
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static String toJpaDirection(Sort.Order order) {
        return order.getDirection().name().toLowerCase(Locale.US);
    }

    public static String detectAlias(String query) {
        Matcher matcher = ALIAS_MATCH.matcher(query);
        return matcher.find() ? matcher.group(2) : null;
    }

    public static <T> Query applyAndBind(String queryString, Iterable<T> entities, EntityManager entityManager) {
        Assert.notNull((Object)queryString);
        Assert.notNull(entities);
        Assert.notNull((Object)entityManager);
        Iterator<T> iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return entityManager.createQuery(queryString);
        }
        String alias = QueryUtils.detectAlias(queryString);
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" where");
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            builder.append(String.format(" %s = ?%d", alias, ++i));
            if (!iterator.hasNext()) continue;
            builder.append(" or");
        }
        Query query = entityManager.createQuery(builder.toString());
        iterator = entities.iterator();
        i = 0;
        while (iterator.hasNext()) {
            query.setParameter(++i, iterator.next());
        }
        return query;
    }

    public static String createCountQueryFor(String originalQuery) {
        Assert.hasText((String)originalQuery);
        Matcher matcher = COUNT_MATCH.matcher(originalQuery);
        return matcher.replaceFirst(COUNT_REPLACEMENT);
    }

    public static boolean hasNamedParameter(Query query) {
        for (Parameter parameter : query.getParameters()) {
            if (parameter.getName() == null) continue;
            return true;
        }
        return false;
    }

    public static List<Order> toOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (sort == null) {
            return orders;
        }
        Assert.notNull(root);
        Assert.notNull((Object)cb);
        for (Sort.Order order : sort) {
            orders.add(QueryUtils.toJpaOrder(order, root, cb));
        }
        return orders;
    }

    private static Order toJpaOrder(Sort.Order order, Root<?> root, CriteriaBuilder cb) {
        Expression expression = QueryUtils.toExpressionRecursively(root, PropertyPath.from((String)order.getProperty(), (Class)root.getJavaType()));
        return order.isAscending() ? cb.asc(expression) : cb.desc(expression);
    }

    static <T> Expression<T> toExpressionRecursively(From<?, ?> from, PropertyPath property) {
        if (property.isCollection()) {
            Expression<T> join = from.join(property.getSegment());
            return property.hasNext() ? QueryUtils.toExpressionRecursively(join, property.next()) : join;
        }
        Expression<Object> path = from.get(property.getSegment());
        return property.hasNext() ? QueryUtils.toExpressionRecursively((Path<Object>)path, property.next()) : path;
    }

    static Expression<Object> toExpressionRecursively(Path<Object> path, PropertyPath property) {
        Expression<Object> result = path.get(property.getSegment());
        return property.hasNext() ? QueryUtils.toExpressionRecursively((Path<Object>)result, property.next()) : result;
    }

    static {
        IDENTIFIER_GROUP = String.format("(%s)", IDENTIFIER);
        StringBuilder builder = new StringBuilder();
        builder.append("(?<=from)");
        builder.append("(?: )+");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(?: as)*");
        builder.append("(?: )+");
        builder.append("(\\w*)");
        ALIAS_MATCH = Pattern.compile(builder.toString(), 2);
        builder = new StringBuilder();
        builder.append("(select\\s+((distinct )?.+?)\\s+)?(from\\s+");
        builder.append(IDENTIFIER);
        builder.append("(?:\\s+as)?\\s+)");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(.*)");
        COUNT_MATCH = Pattern.compile(builder.toString(), 2);
    }
}

