/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JpaRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<EntityManager> entityManagerBean;

    JpaRepositoryBean(BeanManager beanManager, Bean<EntityManager> entityManagerBean, Set<Annotation> qualifiers, Class<T> repositoryType) {
        super(qualifiers, repositoryType, beanManager);
        Assert.notNull(entityManagerBean);
        this.entityManagerBean = entityManagerBean;
    }

    public T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        EntityManager entityManager = (EntityManager)this.getDependencyInstance(this.entityManagerBean, EntityManager.class);
        JpaRepositoryFactory factory = new JpaRepositoryFactory(entityManager);
        return (T)factory.getRepository(repositoryType);
    }

    public Class<? extends Annotation> getScope() {
        return this.entityManagerBean.getScope();
    }
}

