/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.okhttp;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.servo.monitor.Monitors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancedBackOffPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryListenerFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.okhttp.OkHttpLoadBalancingClient;
import org.springframework.cloud.netflix.ribbon.okhttp.RetryableOkHttpLoadBalancingClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"ribbon.okhttp.enabled"})
@ConditionalOnClass(name={"okhttp3.OkHttpClient"})
public class OkHttpRibbonConfiguration {
    @Value(value="${ribbon.client.name}")
    private String name = "client";

    @Bean
    @ConditionalOnMissingBean(value={AbstractLoadBalancerAwareClient.class})
    @ConditionalOnClass(name={"org.springframework.retry.support.RetryTemplate"})
    public RetryableOkHttpLoadBalancingClient retryableOkHttpLoadBalancingClient(IClientConfig config, ServerIntrospector serverIntrospector, ILoadBalancer loadBalancer, RetryHandler retryHandler, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory, OkHttpClient delegate, LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory, LoadBalancedRetryListenerFactory loadBalancedRetryListenerFactory) {
        RetryableOkHttpLoadBalancingClient client = new RetryableOkHttpLoadBalancingClient(delegate, config, serverIntrospector, loadBalancedRetryPolicyFactory, loadBalancedBackOffPolicyFactory, loadBalancedRetryListenerFactory);
        client.setLoadBalancer(loadBalancer);
        client.setRetryHandler(retryHandler);
        Monitors.registerObject((String)("Client_" + this.name), (Object)((Object)client));
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractLoadBalancerAwareClient.class})
    @ConditionalOnMissingClass(value={"org.springframework.retry.support.RetryTemplate"})
    public OkHttpLoadBalancingClient okHttpLoadBalancingClient(IClientConfig config, ServerIntrospector serverIntrospector, ILoadBalancer loadBalancer, RetryHandler retryHandler, OkHttpClient delegate) {
        OkHttpLoadBalancingClient client = new OkHttpLoadBalancingClient(delegate, config, serverIntrospector);
        client.setLoadBalancer(loadBalancer);
        client.setRetryHandler(retryHandler);
        Monitors.registerObject((String)("Client_" + this.name), (Object)((Object)client));
        return client;
    }

    @Configuration
    protected static class OkHttpClientConfiguration {
        private OkHttpClient httpClient;

        protected OkHttpClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ConnectionPool.class})
        public ConnectionPool httpClientConnectionPool(IClientConfig config, OkHttpClientConnectionPoolFactory connectionPoolFactory) {
            Integer maxTotalConnections = config.getPropertyAsInteger(CommonClientConfigKey.MaxTotalConnections, 200);
            Object timeToLiveObj = config.getProperty(CommonClientConfigKey.PoolKeepAliveTime);
            Long timeToLive = 900L;
            Object ttlUnitObj = config.getProperty(CommonClientConfigKey.PoolKeepAliveTimeUnits);
            TimeUnit ttlUnit = DefaultClientConfigImpl.DEFAULT_POOL_KEEP_ALIVE_TIME_UNITS;
            if (timeToLiveObj instanceof Long) {
                timeToLive = (Long)timeToLiveObj;
            }
            if (ttlUnitObj instanceof TimeUnit) {
                ttlUnit = (TimeUnit)((Object)ttlUnitObj);
            }
            return connectionPoolFactory.create(maxTotalConnections.intValue(), timeToLive.longValue(), ttlUnit);
        }

        @Bean
        @ConditionalOnMissingBean(value={OkHttpClient.class})
        public OkHttpClient client(OkHttpClientFactory httpClientFactory, ConnectionPool connectionPool, IClientConfig config) {
            Boolean followRedirects = config.getPropertyAsBoolean(CommonClientConfigKey.FollowRedirects, DefaultClientConfigImpl.DEFAULT_FOLLOW_REDIRECTS.booleanValue());
            Integer connectTimeout = config.getPropertyAsInteger(CommonClientConfigKey.ConnectTimeout, 2000);
            Integer readTimeout = config.getPropertyAsInteger(CommonClientConfigKey.ReadTimeout, 5000);
            this.httpClient = httpClientFactory.createBuilder(false).connectTimeout((long)connectTimeout.intValue(), TimeUnit.MILLISECONDS).readTimeout((long)readTimeout.intValue(), TimeUnit.MILLISECONDS).followRedirects(followRedirects.booleanValue()).connectionPool(connectionPool).build();
            return this.httpClient;
        }

        @PreDestroy
        public void destroy() {
            if (this.httpClient != null) {
                this.httpClient.dispatcher().executorService().shutdown();
                this.httpClient.connectionPool().evictAll();
            }
        }
    }
}

