/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import com.netflix.zuul.context.RequestContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.util.MultiValueMap;

public class TraceProxyRequestHelper
extends ProxyRequestHelper {
    private static final Log log = LogFactory.getLog(TraceProxyRequestHelper.class);
    private TraceRepository traces;

    public void setTraces(TraceRepository traces) {
        this.traces = traces;
    }

    @Override
    public Map<String, Object> debug(String verb, String uri, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) throws IOException {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        if (this.traces != null) {
            RequestContext context = RequestContext.getCurrentContext();
            info.put("method", verb);
            info.put("path", uri);
            info.put("query", this.getQueryString(params));
            info.put("remote", true);
            info.put("proxy", context.get((Object)"proxy"));
            LinkedHashMap<String, LinkedHashMap<String, Object>> trace = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
            LinkedHashMap<String, Object> input = new LinkedHashMap<String, Object>();
            trace.put("request", input);
            info.put("headers", trace);
            this.debugHeaders(headers, input);
            RequestContext ctx = RequestContext.getCurrentContext();
            if (this.shouldDebugBody(ctx) && requestEntity != null) {
                this.debugRequestEntity(info, (InputStream)ctx.getRequest().getInputStream());
            }
            this.traces.add(info);
            return info;
        }
        return info;
    }

    void debugHeaders(MultiValueMap<String, String> headers, Map<String, Object> map) {
        for (Map.Entry entry : headers.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            Object value = collection;
            if (collection.size() < 2) {
                value = collection.isEmpty() ? "" : (String)collection.iterator().next();
            }
            map.put((String)entry.getKey(), value);
        }
    }

    @Override
    public void appendDebug(Map<String, Object> info, int status, MultiValueMap<String, String> headers) {
        if (this.traces != null) {
            Map trace = (Map)info.get("headers");
            LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
            trace.put("response", output);
            this.debugHeaders(headers, output);
            output.put("status", "" + status);
        }
    }

    private void debugRequestEntity(Map<String, Object> info, InputStream inputStream) throws IOException {
        if (RequestContext.getCurrentContext().isChunkedRequestBody()) {
            info.put("body", "<chunked>");
            return;
        }
        char[] buffer = new char[4096];
        int count = new InputStreamReader(inputStream, Charset.forName("UTF-8")).read(buffer, 0, buffer.length);
        if (count > 0) {
            String entity = new String(buffer).substring(0, count);
            info.put("body", entity.length() < 4096 ? entity : entity + "<truncated>");
        }
    }
}

