/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.Server;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.BooleanUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.feign.ribbon.FeignRetryPolicy;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpRequest;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpResponse;
import org.springframework.cloud.netflix.ribbon.apache.RibbonLoadBalancingHttpClient;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RetryableRibbonLoadBalancingHttpClient
extends RibbonLoadBalancingHttpClient
implements ServiceInstanceChooser {
    private LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory = new LoadBalancedRetryPolicyFactory.NeverRetryFactory();

    public RetryableRibbonLoadBalancingHttpClient(IClientConfig config, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory) {
        super(config, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
    }

    @Override
    public RibbonApacheHttpResponse execute(final RibbonApacheHttpRequest request, final IClientConfig configOverride) throws Exception {
        RequestConfig.Builder builder = RequestConfig.custom();
        IClientConfig config = configOverride != null ? configOverride : this.config;
        builder.setConnectTimeout(((Integer)config.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue());
        builder.setSocketTimeout(((Integer)config.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue());
        builder.setRedirectsEnabled(((Boolean)config.get(CommonClientConfigKey.FollowRedirects, (Object)this.followRedirects)).booleanValue());
        final RequestConfig requestConfig = builder.build();
        return this.executeWithRetry(request, (RetryCallback<RibbonApacheHttpResponse, IOException>)new RetryCallback(){

            public RibbonApacheHttpResponse doWithRetry(RetryContext context) throws Exception {
                ServiceInstance service;
                RibbonApacheHttpRequest newRequest = request;
                if (context instanceof LoadBalancedRetryContext && (service = ((LoadBalancedRetryContext)context).getServiceInstance()) != null) {
                    newRequest = newRequest.withNewUri(new URI(service.getUri().getScheme(), newRequest.getURI().getUserInfo(), service.getHost(), service.getPort(), newRequest.getURI().getPath(), newRequest.getURI().getQuery(), newRequest.getURI().getFragment()));
                }
                if (RetryableRibbonLoadBalancingHttpClient.this.isSecure(configOverride)) {
                    URI secureUri = UriComponentsBuilder.fromUri((URI)newRequest.getUri()).scheme("https").build().toUri();
                    newRequest = newRequest.withNewUri(secureUri);
                }
                HttpUriRequest httpUriRequest = newRequest.toRequest(requestConfig);
                HttpResponse httpResponse = ((HttpClient)RetryableRibbonLoadBalancingHttpClient.this.delegate).execute(httpUriRequest);
                return new RibbonApacheHttpResponse(httpResponse, httpUriRequest.getURI());
            }
        });
    }

    private RibbonApacheHttpResponse executeWithRetry(RibbonApacheHttpRequest request, RetryCallback<RibbonApacheHttpResponse, IOException> callback) throws Exception {
        LoadBalancedRetryPolicy retryPolicy = this.loadBalancedRetryPolicyFactory.create(this.getClientName(), (ServiceInstanceChooser)this);
        RetryTemplate retryTemplate = new RetryTemplate();
        boolean retryable = request.getContext() == null ? true : BooleanUtils.toBooleanDefaultIfNull((Boolean)request.getContext().getRetryable(), (boolean)true);
        retryTemplate.setRetryPolicy((org.springframework.retry.RetryPolicy)(retryPolicy == null || !retryable ? new NeverRetryPolicy() : new RetryPolicy(request, retryPolicy, this, this.getClientName())));
        return (RibbonApacheHttpResponse)retryTemplate.execute(callback);
    }

    public ServiceInstance choose(String serviceId) {
        Server server = this.getLoadBalancer().chooseServer((Object)serviceId);
        return new RibbonLoadBalancerClient.RibbonServer(serviceId, server);
    }

    @Override
    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(RibbonApacheHttpRequest request, IClientConfig requestConfig) {
        return new RequestSpecificRetryHandler(false, false, RetryHandler.DEFAULT, null);
    }

    static class RetryPolicy
    extends FeignRetryPolicy {
        public RetryPolicy(HttpRequest request, LoadBalancedRetryPolicy policy, ServiceInstanceChooser serviceInstanceChooser, String serviceName) {
            super(request, policy, serviceInstanceChooser, serviceName);
        }
    }
}

