/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.http.HttpMethod;

public class RibbonLoadBalancedRetryPolicyFactory
implements LoadBalancedRetryPolicyFactory {
    private SpringClientFactory clientFactory;

    public RibbonLoadBalancedRetryPolicyFactory(SpringClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public LoadBalancedRetryPolicy create(final String serviceId, final ServiceInstanceChooser loadBalanceChooser) {
        final RibbonLoadBalancerContext lbContext = this.clientFactory.getLoadBalancerContext(serviceId);
        return new LoadBalancedRetryPolicy(){
            private int sameServerCount = 0;
            private int nextServerCount = 0;
            private ServiceInstance lastServiceInstance = null;

            public boolean canRetry(LoadBalancedRetryContext context) {
                HttpMethod method = context.getRequest().getMethod();
                return HttpMethod.GET == method || lbContext.isOkToRetryOnAllOperations();
            }

            public boolean canRetrySameServer(LoadBalancedRetryContext context) {
                return this.sameServerCount < lbContext.getRetryHandler().getMaxRetriesOnSameServer() && this.canRetry(context);
            }

            public boolean canRetryNextServer(LoadBalancedRetryContext context) {
                return this.nextServerCount <= lbContext.getRetryHandler().getMaxRetriesOnNextServer() && this.canRetry(context);
            }

            public void close(LoadBalancedRetryContext context) {
            }

            public void registerThrowable(LoadBalancedRetryContext context, Throwable throwable) {
                if (!this.canRetrySameServer(context) && this.canRetryNextServer(context)) {
                    context.setServiceInstance(loadBalanceChooser.choose(serviceId));
                }
                if (this.sameServerCount >= lbContext.getRetryHandler().getMaxRetriesOnSameServer() && this.canRetry(context)) {
                    this.sameServerCount = 0;
                    ++this.nextServerCount;
                    if (!this.canRetryNextServer(context)) {
                        context.setExhaustedOnly();
                    }
                } else {
                    ++this.sameServerCount;
                }
            }
        };
    }
}

