/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.archaius;

import com.netflix.config.AggregatedConfiguration;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicURLConfiguration;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationBuilder;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.netflix.archaius.ArchaiusEndpoint;
import org.springframework.cloud.netflix.archaius.ConfigurableEnvironmentConfiguration;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={ConcurrentCompositeConfiguration.class, ConfigurationBuilder.class})
public class ArchaiusAutoConfiguration {
    private static final Log log = LogFactory.getLog(ArchaiusAutoConfiguration.class);
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    @Autowired
    private ConfigurableEnvironment env;
    @Autowired
    private List<AbstractConfiguration> externalConfigurations;

    @PreDestroy
    public void close() {
        ArchaiusAutoConfiguration.setStatic(ConfigurationManager.class, "instance", null);
        ArchaiusAutoConfiguration.setStatic(ConfigurationManager.class, "customConfigurationInstalled", false);
        ArchaiusAutoConfiguration.setStatic(DynamicPropertyFactory.class, "config", null);
        ArchaiusAutoConfiguration.setStatic(DynamicPropertyFactory.class, "initializedWithDefaultConfig", false);
        ArchaiusAutoConfiguration.setStatic(DynamicProperty.class, "dynamicPropertySupportImpl", null);
        initialized.compareAndSet(true, false);
    }

    @Bean
    public ConfigurableEnvironmentConfiguration configurableEnvironmentConfiguration() {
        ConfigurableEnvironmentConfiguration envConfig = new ConfigurableEnvironmentConfiguration(this.env);
        this.configureArchaius(envConfig);
        return envConfig;
    }

    protected void configureArchaius(ConfigurableEnvironmentConfiguration envConfig) {
        if (initialized.compareAndSet(false, true)) {
            String appName = this.env.getProperty("spring.application.name");
            if (appName == null) {
                appName = "application";
                log.warn((Object)"No spring.application.name found, defaulting to 'application'");
            }
            System.setProperty(DeploymentContext.ContextKey.appId.getKey(), appName);
            ConcurrentCompositeConfiguration config = new ConcurrentCompositeConfiguration();
            if (this.externalConfigurations != null) {
                for (AbstractConfiguration externalConfig : this.externalConfigurations) {
                    config.addConfiguration(externalConfig);
                }
            }
            config.addConfiguration((AbstractConfiguration)envConfig, ConfigurableEnvironmentConfiguration.class.getSimpleName());
            DynamicURLConfiguration defaultURLConfig = new DynamicURLConfiguration();
            try {
                config.addConfiguration((AbstractConfiguration)defaultURLConfig, "archaius.dynamicPropertyFactory.URL_CONFIG");
            }
            catch (Throwable ex) {
                log.error((Object)("Cannot create config from " + defaultURLConfig), ex);
            }
            if (!Boolean.getBoolean("archaius.dynamicProperty.disableSystemConfig")) {
                SystemConfiguration sysConfig = new SystemConfiguration();
                config.addConfiguration((AbstractConfiguration)sysConfig, "archaius.dynamicPropertyFactory.SYS_CONFIG");
            }
            if (!Boolean.getBoolean("archaius.dynamicProperty.disableEnvironmentConfig")) {
                EnvironmentConfiguration environmentConfiguration = new EnvironmentConfiguration();
                config.addConfiguration((AbstractConfiguration)environmentConfiguration, "archaius.dynamicPropertyFactory.ENV_CONFIG");
            }
            ConcurrentCompositeConfiguration appOverrideConfig = new ConcurrentCompositeConfiguration();
            config.addConfiguration((AbstractConfiguration)appOverrideConfig, "APPLICATION_PROPERTIES");
            config.setContainerConfigurationIndex(config.getIndexOfConfiguration((AbstractConfiguration)appOverrideConfig));
            this.addArchaiusConfiguration(config);
        } else {
            log.warn((Object)"Netflix ConfigurationManager has already been installed, unable to re-install");
        }
    }

    private void addArchaiusConfiguration(ConcurrentCompositeConfiguration config) {
        if (ConfigurationManager.isConfigurationInstalled()) {
            AbstractConfiguration installedConfiguration = ConfigurationManager.getConfigInstance();
            if (installedConfiguration instanceof ConcurrentCompositeConfiguration) {
                ConcurrentCompositeConfiguration configInstance = (ConcurrentCompositeConfiguration)installedConfiguration;
                configInstance.addConfiguration((AbstractConfiguration)config);
            } else {
                installedConfiguration.append((org.apache.commons.configuration.Configuration)config);
                if (!(installedConfiguration instanceof AggregatedConfiguration)) {
                    log.warn((Object)"Appending a configuration to an existing non-aggregated installed configuration will have no effect");
                }
            }
        } else {
            ConfigurationManager.install((AbstractConfiguration)config);
        }
    }

    private static void setStatic(Class<?> type, String name, Object value) {
        Field field = ReflectionUtils.findField(type, (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, null, (Object)value);
    }

    @Configuration
    @ConditionalOnProperty(value={"archaius.propagate.environmentChangedEvent"}, matchIfMissing=true)
    @ConditionalOnClass(value={EnvironmentChangeEvent.class})
    protected static class PropagateEventsConfiguration
    implements ApplicationListener<EnvironmentChangeEvent> {
        @Autowired
        private Environment env;

        protected PropagateEventsConfiguration() {
        }

        public void onApplicationEvent(EnvironmentChangeEvent event) {
            AbstractConfiguration manager = ConfigurationManager.getConfigInstance();
            for (String key : event.getKeys()) {
                for (ConfigurationListener listener : manager.getConfigurationListeners()) {
                    Object source = event.getSource();
                    int type = 3;
                    String value = this.env.getProperty(key);
                    boolean beforeUpdate = false;
                    listener.configurationChanged(new ConfigurationEvent(source, type, key, (Object)value, beforeUpdate));
                }
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    @ConditionalOnEnabledEndpoint(value="archaius")
    protected static class ArchaiusEndpointConfiguration {
        protected ArchaiusEndpointConfiguration() {
        }

        @Bean
        protected ArchaiusEndpoint archaiusEndpoint() {
            return new ArchaiusEndpoint();
        }
    }
}

