/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aws.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.springframework.aws.maven.AbstractWagon;
import org.springframework.aws.maven.TransferProgress;
import org.springframework.aws.maven.TransferProgressFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStorageServiceWagon
extends AbstractWagon {
    private S3Service service;
    private S3Bucket bucket;
    private String basedir;

    public SimpleStorageServiceWagon() {
        super(false);
    }

    @Override
    protected void connectToRepository(Repository source, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws AuthenticationException {
        try {
            this.service = new RestS3Service(this.getCredentials(authenticationInfo));
        }
        catch (S3ServiceException e) {
            throw new AuthenticationException("Cannot authenticate with current credentials", (Throwable)e);
        }
        this.bucket = new S3Bucket(source.getHost());
        this.basedir = this.getBaseDir(source);
    }

    @Override
    protected boolean doesRemoteResourceExist(String resourceName) {
        try {
            this.service.getObjectDetails(this.bucket, this.basedir + resourceName);
        }
        catch (S3ServiceException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void disconnectFromRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getResource(String resourceName, File destination, TransferProgress progress) throws ResourceDoesNotExistException, S3ServiceException, IOException {
        S3Object object;
        try {
            object = this.service.getObject(this.bucket, this.basedir + resourceName);
        }
        catch (S3ServiceException e) {
            throw new ResourceDoesNotExistException("Resource " + resourceName + " does not exist in the repository", (Throwable)e);
        }
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        InputStream in = null;
        TransferProgressFileOutputStream out = null;
        try {
            int length;
            in = object.getDataInputStream();
            out = new TransferProgressFileOutputStream(destination, progress);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    protected boolean isRemoteResourceNewer(String resourceName, long timestamp) throws S3ServiceException {
        S3Object object = this.service.getObjectDetails(this.bucket, this.basedir + resourceName);
        return object.getLastModifiedDate().compareTo(new Date(timestamp)) < 0;
    }

    @Override
    protected List<String> listDirectory(String directory) throws Exception {
        S3Object[] objects = this.service.listObjects(this.bucket, this.basedir + directory, "");
        ArrayList<String> fileNames = new ArrayList<String>(objects.length);
        for (S3Object object : objects) {
            fileNames.add(object.getKey());
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putResource(File source, String destination, TransferProgress progress) throws S3ServiceException, IOException {
        this.buildDestinationPath(this.getDestinationPath(destination));
        S3Object object = new S3Object(this.basedir + destination);
        object.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        object.setDataInputFile(source);
        object.setContentLength(source.length());
        InputStream in = null;
        try {
            int length;
            this.service.putObject(this.bucket, object);
            in = new FileInputStream(source);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) != -1) {
                progress.notify(buffer, length);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void buildDestinationPath(String destination) throws S3ServiceException {
        S3Object object = new S3Object(this.basedir + destination + "/");
        object.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        object.setContentLength(0L);
        this.service.putObject(this.bucket, object);
        int index = destination.lastIndexOf(47);
        if (index != -1) {
            this.buildDestinationPath(destination.substring(0, index));
        }
    }

    private String getDestinationPath(String destination) {
        return destination.substring(0, destination.lastIndexOf(47));
    }

    private String getBaseDir(Repository source) {
        StringBuilder sb = new StringBuilder(source.getBasedir());
        sb.deleteCharAt(0);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    private AWSCredentials getCredentials(AuthenticationInfo authenticationInfo) throws AuthenticationException {
        if (authenticationInfo == null) {
            return null;
        }
        String accessKey = authenticationInfo.getUserName();
        String secretKey = authenticationInfo.getPassphrase();
        if (accessKey == null || secretKey == null) {
            throw new AuthenticationException("S3 requires a username and passphrase to be set");
        }
        return new AWSCredentials(accessKey, secretKey);
    }
}

