/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.batch.core.jsr.JsrStepContextFactoryBean;
import org.springframework.batch.core.jsr.configuration.support.BatchArtifactType;
import org.springframework.batch.core.jsr.configuration.xml.FlowParser;
import org.springframework.batch.core.jsr.configuration.xml.JobFactoryBean;
import org.springframework.batch.core.jsr.configuration.xml.JsrJobListenerFactoryBean;
import org.springframework.batch.core.jsr.configuration.xml.JsrNamespaceUtils;
import org.springframework.batch.core.jsr.configuration.xml.ListenerParser;
import org.springframework.batch.core.jsr.configuration.xml.PropertyParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JsrJobParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ID_ATTRIBUTE = "id";
    private static final String RESTARTABLE_ATTRIBUTE = "restartable";

    protected Class<JobFactoryBean> getBeanClass(Element element) {
        return JobFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        CoreNamespaceUtils.autoregisterBeansForNamespace(parserContext, parserContext.extractSource((Object)element));
        JsrNamespaceUtils.autoregisterJsrBeansForNamespace(parserContext);
        String jobName = element.getAttribute(ID_ATTRIBUTE);
        builder.setLazyInit(true);
        builder.addConstructorArgValue((Object)jobName);
        builder.addPropertyReference("jobExplorer", "jobExplorer");
        String restartableAttribute = element.getAttribute(RESTARTABLE_ATTRIBUTE);
        if (StringUtils.hasText((String)restartableAttribute)) {
            builder.addPropertyValue(RESTARTABLE_ATTRIBUTE, (Object)restartableAttribute);
        }
        new PropertyParser(jobName, parserContext, BatchArtifactType.JOB).parseProperties(element);
        BeanDefinition flowDef = new FlowParser(jobName, jobName).parse(element, parserContext);
        builder.addPropertyValue("flow", (Object)flowDef);
        AbstractBeanDefinition stepContextBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(JsrStepContextFactoryBean.class).getBeanDefinition();
        stepContextBeanDefinition.setScope("step");
        parserContext.getRegistry().registerBeanDefinition("stepContextFactory", (BeanDefinition)stepContextBeanDefinition);
        new ListenerParser(JsrJobListenerFactoryBean.class, "jobExecutionListeners").parseListeners(element, parserContext, builder);
    }
}

