/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.core.step.item.FaultTolerantStepFactoryBean;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OffsetItemReader<T>
implements ItemReader<T>,
ItemStream {
    private static final String OFFSET_KEY = FaultTolerantStepFactoryBean.class.getName() + ".OFFSET_KEY";
    private final ItemReader<? extends T> itemReader;
    private int offset;

    public OffsetItemReader(ItemReader<? extends T> itemReader) {
        this.itemReader = itemReader;
    }

    public T read() throws Exception, UnexpectedInputException, ParseException {
        for (int i = 0; i < this.offset; ++i) {
            this.itemReader.read();
        }
        this.offset = 0;
        return (T)this.itemReader.read();
    }

    public void close() throws ItemStreamException {
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.offset = executionContext.getInt(OFFSET_KEY, 0);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        executionContext.putInt(OFFSET_KEY, this.offset);
    }
}

