/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.batch.core.configuration.xml.StepListenerParser;
import org.springframework.batch.core.configuration.xml.StepParserStepFactoryBean;
import org.springframework.batch.core.configuration.xml.TaskletParser;
import org.springframework.batch.core.listener.StepListenerMetaData;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractStepParser {
    protected static final String ID_ATTR = "id";
    private static final String PARENT_ATTR = "parent";
    private static final String REF_ATTR = "ref";
    private static final String TASKLET_ELE = "tasklet";
    private static final String PARTITION_ELE = "partition";
    private static final String JOB_ELE = "job";
    private static final String JOB_PARAMS_EXTRACTOR_ATTR = "job-parameters-extractor";
    private static final String JOB_LAUNCHER_ATTR = "job-launcher";
    private static final String STEP_ATTR = "step";
    private static final String STEP_ELE = "step";
    private static final String PARTITIONER_ATTR = "partitioner";
    private static final String AGGREGATOR_ATTR = "aggregator";
    private static final String HANDLER_ATTR = "handler";
    private static final String HANDLER_ELE = "handler";
    private static final String TASK_EXECUTOR_ATTR = "task-executor";
    private static final String GRID_SIZE_ATTR = "grid-size";
    private static final String FLOW_ELE = "flow";
    private static final String JOB_REPO_ATTR = "job-repository";
    private static final StepListenerParser stepListenerParser = new StepListenerParser(StepListenerMetaData.stepExecutionListenerMetaData());

    protected AbstractBeanDefinition parseStep(Element stepElement, ParserContext parserContext, String jobFactoryRef) {
        String jobRepositoryRef;
        String isAbstract;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        AbstractBeanDefinition bd = builder.getRawBeanDefinition();
        NodeList children = stepElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node nd = children.item(i);
            if (!(nd instanceof Element)) continue;
            Element nestedElement = (Element)nd;
            String name = nestedElement.getLocalName();
            if (TASKLET_ELE.equals(name)) {
                boolean stepUnderspecified = CoreNamespaceUtils.isUnderspecified(stepElement);
                new TaskletParser().parseTasklet(stepElement, nestedElement, bd, parserContext, stepUnderspecified);
                continue;
            }
            if (FLOW_ELE.equals(name)) {
                boolean stepUnderspecified = CoreNamespaceUtils.isUnderspecified(stepElement);
                this.parseFlow(stepElement, nestedElement, bd, parserContext, stepUnderspecified);
                continue;
            }
            if (PARTITION_ELE.equals(name)) {
                boolean stepUnderspecified = CoreNamespaceUtils.isUnderspecified(stepElement);
                this.parsePartition(stepElement, nestedElement, bd, parserContext, stepUnderspecified, jobFactoryRef);
                continue;
            }
            if (JOB_ELE.equals(name)) {
                boolean stepUnderspecified = CoreNamespaceUtils.isUnderspecified(stepElement);
                this.parseJob(stepElement, nestedElement, bd, parserContext, stepUnderspecified);
                continue;
            }
            if ("description".equals(name)) {
                bd.setDescription(nestedElement.getTextContent());
                continue;
            }
            String ns = nestedElement.getNamespaceURI();
            BeanDefinition value = null;
            boolean skip = false;
            if (ns == null && name.equals("bean") || ns.equals("http://www.springframework.org/schema/beans")) {
                BeanDefinitionHolder holder = parserContext.getDelegate().parseBeanDefinitionElement(nestedElement);
                value = parserContext.getDelegate().decorateBeanDefinitionIfRequired(nestedElement, holder);
            } else if (ns.equals("http://www.springframework.org/schema/batch")) {
                skip = true;
            } else {
                value = parserContext.getDelegate().parseCustomElement(nestedElement);
            }
            if (skip) continue;
            bd.setBeanClass(StepParserStepFactoryBean.class);
            bd.setAttribute("isNamespaceStep", (Object)true);
            builder.addPropertyValue(TASKLET_ELE, (Object)value);
        }
        String parentRef = stepElement.getAttribute(PARENT_ATTR);
        if (StringUtils.hasText((String)parentRef)) {
            bd.setParentName(parentRef);
        }
        if (StringUtils.hasText((String)(isAbstract = stepElement.getAttribute("abstract")))) {
            bd.setAbstract(Boolean.valueOf(isAbstract).booleanValue());
        }
        if (StringUtils.hasText((String)(jobRepositoryRef = stepElement.getAttribute(JOB_REPO_ATTR)))) {
            builder.addPropertyReference("jobRepository", jobRepositoryRef);
        }
        if (StringUtils.hasText((String)jobFactoryRef)) {
            bd.setAttribute("jobParserJobFactoryBeanRef", (Object)jobFactoryRef);
        }
        stepListenerParser.handleListenersElement(stepElement, (BeanDefinition)bd, parserContext);
        return bd;
    }

    private void parsePartition(Element stepElement, Element partitionElement, AbstractBeanDefinition bd, ParserContext parserContext, boolean stepUnderspecified, String jobFactoryRef) {
        bd.setBeanClass(StepParserStepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", (Object)true);
        String stepRef = partitionElement.getAttribute("step");
        String partitionerRef = partitionElement.getAttribute(PARTITIONER_ATTR);
        String aggregatorRef = partitionElement.getAttribute(AGGREGATOR_ATTR);
        String handlerRef = partitionElement.getAttribute("handler");
        if (!StringUtils.hasText((String)partitionerRef)) {
            parserContext.getReaderContext().error("You must specify a partitioner", (Object)partitionElement);
            return;
        }
        MutablePropertyValues propertyValues = bd.getPropertyValues();
        propertyValues.addPropertyValue(PARTITIONER_ATTR, (Object)new RuntimeBeanReference(partitionerRef));
        if (StringUtils.hasText((String)aggregatorRef)) {
            propertyValues.addPropertyValue("stepExecutionAggregator", (Object)new RuntimeBeanReference(aggregatorRef));
        }
        boolean customHandler = false;
        if (!StringUtils.hasText((String)handlerRef)) {
            Element handlerElement = DomUtils.getChildElementByTagName((Element)partitionElement, (String)"handler");
            if (handlerElement != null) {
                String gridSize;
                String taskExecutorRef = handlerElement.getAttribute(TASK_EXECUTOR_ATTR);
                if (StringUtils.hasText((String)taskExecutorRef)) {
                    propertyValues.addPropertyValue("taskExecutor", (Object)new RuntimeBeanReference(taskExecutorRef));
                }
                if (StringUtils.hasText((String)(gridSize = handlerElement.getAttribute(GRID_SIZE_ATTR)))) {
                    propertyValues.addPropertyValue("gridSize", (Object)new TypedStringValue(gridSize));
                }
            }
        } else {
            customHandler = true;
            AbstractBeanDefinition partitionHandler = BeanDefinitionBuilder.genericBeanDefinition().getRawBeanDefinition();
            partitionHandler.setParentName(handlerRef);
            propertyValues.addPropertyValue("partitionHandler", (Object)partitionHandler);
        }
        Element inlineStepElement = DomUtils.getChildElementByTagName((Element)partitionElement, (String)"step");
        if (inlineStepElement == null && !StringUtils.hasText((String)stepRef) && !customHandler) {
            parserContext.getReaderContext().error("You must specify a step", (Object)partitionElement);
            return;
        }
        if (StringUtils.hasText((String)stepRef)) {
            propertyValues.addPropertyValue("step", (Object)new RuntimeBeanReference(stepRef));
        } else if (inlineStepElement != null) {
            AbstractBeanDefinition stepDefinition = this.parseStep(inlineStepElement, parserContext, jobFactoryRef);
            stepDefinition.getPropertyValues().addPropertyValue("name", (Object)stepElement.getAttribute(ID_ATTR));
            propertyValues.addPropertyValue("step", (Object)stepDefinition);
        }
    }

    private void parseJob(Element stepElement, Element jobElement, AbstractBeanDefinition bd, ParserContext parserContext, boolean stepUnderspecified) {
        bd.setBeanClass(StepParserStepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", (Object)true);
        String jobRef = jobElement.getAttribute(REF_ATTR);
        if (!StringUtils.hasText((String)jobRef)) {
            parserContext.getReaderContext().error("You must specify a job", (Object)jobElement);
            return;
        }
        MutablePropertyValues propertyValues = bd.getPropertyValues();
        propertyValues.addPropertyValue(JOB_ELE, (Object)new RuntimeBeanReference(jobRef));
        String jobParametersExtractor = jobElement.getAttribute(JOB_PARAMS_EXTRACTOR_ATTR);
        String jobLauncher = jobElement.getAttribute(JOB_LAUNCHER_ATTR);
        if (StringUtils.hasText((String)jobParametersExtractor)) {
            propertyValues.addPropertyValue("jobParametersExtractor", (Object)new RuntimeBeanReference(jobParametersExtractor));
        }
        if (StringUtils.hasText((String)jobLauncher)) {
            propertyValues.addPropertyValue("jobLauncher", (Object)new RuntimeBeanReference(jobLauncher));
        }
    }

    private void parseFlow(Element stepElement, Element flowElement, AbstractBeanDefinition bd, ParserContext parserContext, boolean stepUnderspecified) {
        bd.setBeanClass(StepParserStepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", (Object)true);
        String flowRef = flowElement.getAttribute(PARENT_ATTR);
        String idAttribute = stepElement.getAttribute(ID_ATTR);
        GenericBeanDefinition flowDefinition = new GenericBeanDefinition();
        flowDefinition.setParentName(flowRef);
        MutablePropertyValues propertyValues = flowDefinition.getPropertyValues();
        if (StringUtils.hasText((String)idAttribute)) {
            propertyValues.addPropertyValue("name", (Object)idAttribute);
        }
        bd.getPropertyValues().addPropertyValue(FLOW_ELE, (Object)flowDefinition);
    }
}

