/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp.contentfilter.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class TextEncoder {
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");

    public static CharBuffer encode(ByteBuffer data, String encoding) throws IOException {
        int encodedLength;
        CharBuffer charBuffer;
        CharsetDecoder decoder = TextEncoder.createDecoder(encoding);
        CoderResult coderResult = decoder.decode(data, charBuffer = CharBuffer.allocate(encodedLength = (int)(decoder.maxCharsPerByte() * (float)data.limit())), true);
        if (!coderResult.isUnderflow()) {
            coderResult.throwException();
        }
        if (!(coderResult = decoder.flush(charBuffer)).isUnderflow()) {
            coderResult.throwException();
        }
        charBuffer.flip();
        return charBuffer;
    }

    private static CharsetDecoder createDecoder(String encoding) throws IOException {
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        if (!Charset.isSupported(encoding)) {
            throw new IOException("Unsupported encoding " + encoding);
        }
        Charset charset = Charset.forName(encoding);
        return charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }
}

