/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp.contentfilter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sitemesh.webapp.contentfilter.ContainerTweaks;
import org.sitemesh.webapp.contentfilter.HttpServletRequestFilterable;
import org.sitemesh.webapp.contentfilter.HttpServletResponseBuffer;
import org.sitemesh.webapp.contentfilter.ResponseMetaData;
import org.sitemesh.webapp.contentfilter.Selector;

public abstract class ContentBufferingFilter
implements Filter {
    private final Selector selector;
    private FilterConfig filterConfig;
    private ContainerTweaks containerTweaks;

    protected ContentBufferingFilter(Selector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("selector cannot be null");
        }
        this.selector = selector;
    }

    protected abstract boolean postProcess(String var1, CharBuffer var2, HttpServletRequest var3, HttpServletResponse var4, ResponseMetaData var5) throws IOException, ServletException;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.containerTweaks = this.initContainerTweaks();
    }

    public void destroy() {
        this.filterConfig = null;
        this.containerTweaks = null;
    }

    protected ContainerTweaks initContainerTweaks() {
        return new ContainerTweaks();
    }

    protected FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected ContainerTweaks getContainerTweaks() {
        return this.containerTweaks;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        FilterConfig filterConfig = this.getFilterConfig();
        if (filterConfig == null) {
            throw new ServletException(this.getClass().getName() + ".init() has not been called.");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        ServletContext servletContext = filterConfig.getServletContext();
        if (!this.selector.shouldBufferForRequest(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.containerTweaks.shouldAutoCreateSession()) {
            request.getSession(true);
        }
        try {
            this.bufferAndPostProcess(filterChain, request, response, this.selector);
        }
        catch (IllegalStateException e) {
            if (!this.containerTweaks.shouldIgnoreIllegalStateExceptionOnErrorPage()) {
                throw e;
            }
        }
        catch (RuntimeException e) {
            if (this.containerTweaks.shouldLogUnhandledExceptions()) {
                servletContext.log("Unhandled exception occurred whilst decorating page", (Throwable)e);
            }
            throw e;
        }
    }

    protected void bufferAndPostProcess(FilterChain filterChain, final HttpServletRequest request, final HttpServletResponse response, Selector selector) throws IOException, ServletException {
        final ResponseMetaData metaData = new ResponseMetaData();
        HttpServletResponseBuffer responseBuffer = new HttpServletResponseBuffer(response, metaData, selector){

            public void preCommit() {
                long lastModified = metaData.getLastModified();
                long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                if (lastModified > -1L && !response.containsHeader("Last-Modified")) {
                    if (ifModifiedSince < lastModified / 1000L * 1000L) {
                        response.setDateHeader("Last-Modified", lastModified);
                    } else {
                        response.reset();
                        response.setStatus(304);
                    }
                }
            }
        };
        filterChain.doFilter((ServletRequest)this.wrapRequest(request), (ServletResponse)responseBuffer);
        CharBuffer buffer = responseBuffer.getBuffer();
        boolean processed = false;
        if (buffer != null && !responseBuffer.bufferingWasDisabled()) {
            processed = this.postProcess(responseBuffer.getContentType(), buffer, request, response, metaData);
        }
        if (!response.isCommitted()) {
            responseBuffer.preCommit();
        }
        if (buffer != null && !processed) {
            this.writeOriginal(response, buffer, responseBuffer);
        }
    }

    protected void writeOriginal(HttpServletResponse response, CharBuffer buffer, HttpServletResponseBuffer responseBuffer) throws IOException {
        if (responseBuffer.isBufferStreamBased()) {
            PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());
            writer.append(buffer);
            writer.flush();
            response.getOutputStream().flush();
        } else {
            PrintWriter writer = response.getWriter();
            writer.append(buffer);
            response.getWriter().flush();
        }
    }

    protected HttpServletRequest wrapRequest(HttpServletRequest request) {
        return new HttpServletRequestFilterable(request);
    }
}

