/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.tagprocessor;

import java.io.IOException;
import org.sitemesh.tagprocessor.BasicRule;
import org.sitemesh.tagprocessor.State;
import org.sitemesh.tagprocessor.Tag;

public class StateTransitionRule
extends BasicRule {
    private final State newState;
    private final boolean writeEnclosingTag;
    private State lastState;

    public StateTransitionRule(State newState) {
        this(newState, true);
    }

    public StateTransitionRule(State newState, boolean writeEnclosingTag) {
        this.newState = newState;
        this.writeEnclosingTag = writeEnclosingTag;
    }

    public void process(Tag tag) throws IOException {
        if (tag.getType() == Tag.Type.OPEN) {
            this.lastState = this.tagProcessorContext.currentState();
            this.tagProcessorContext.changeState(this.newState);
            this.newState.addRule(tag.getName().toLowerCase(), this);
        } else if (tag.getType() == Tag.Type.CLOSE && this.lastState != null) {
            this.tagProcessorContext.changeState(this.lastState);
            this.lastState = null;
        }
        if (this.writeEnclosingTag) {
            tag.writeTo(this.tagProcessorContext.currentBuffer());
        }
    }
}

