/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.offline.directory;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sitemesh.offline.directory.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryDirectory
implements Directory {
    private final Charset encoding;
    private final Map<String, ByteBuffer> files = new ConcurrentHashMap<String, ByteBuffer>();

    public InMemoryDirectory() {
        this(Charset.defaultCharset());
    }

    public InMemoryDirectory(Charset encoding) {
        this.encoding = encoding;
    }

    @Override
    public CharBuffer load(String path) throws IOException {
        return this.encoding.newDecoder().decode(this.getDataByPath(path));
    }

    @Override
    public void save(String path, CharBuffer contents) throws IOException {
        this.files.put(path, this.encoding.newEncoder().encode(contents));
    }

    @Override
    public List<String> listAllFilePaths() throws IOException {
        return new ArrayList<String>(this.files.keySet());
    }

    @Override
    public void load(String path, WritableByteChannel channelToWriteTo) throws IOException {
        channelToWriteTo.write(this.getDataByPath(path));
    }

    @Override
    public void save(String path, ReadableByteChannel channelToReadFrom, int length) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(length);
        channelToReadFrom.read(buffer);
        buffer.flip();
        this.files.put(path, buffer);
    }

    @Override
    public void copy(String path, Directory destinationDirectory, String destinationPath) throws IOException {
        final ByteBuffer sourceData = this.getDataByPath(path);
        destinationDirectory.save(destinationPath, new ReadableByteChannel(){

            public int read(ByteBuffer dst) throws IOException {
                ByteBuffer buffer = dst.put(sourceData);
                return buffer.position();
            }

            public boolean isOpen() {
                return true;
            }

            public void close() throws IOException {
            }
        }, sourceData.limit());
    }

    private ByteBuffer getDataByPath(String path) throws IOException {
        ByteBuffer data = this.files.get(path);
        if (data == null) {
            throw new IOException("Not found: " + path);
        }
        return data.duplicate();
    }
}

