/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import org.sitemesh.SiteMeshContext;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentProcessor;

public abstract class BaseSiteMeshContext
implements SiteMeshContext {
    private final ContentProcessor contentProcessor;
    private Content currentContent;

    protected BaseSiteMeshContext(ContentProcessor contentProcessor) {
        this.contentProcessor = contentProcessor;
    }

    protected abstract void decorate(String var1, Content var2, Writer var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content decorate(String decoratorName, Content content) throws IOException {
        if (decoratorName == null) {
            return null;
        }
        class CharBufferWriter
        extends CharArrayWriter {
            CharBufferWriter() {
            }

            public CharBuffer toCharBuffer() {
                return CharBuffer.wrap(this.buf, 0, this.count);
            }
        }
        CharBufferWriter out = new CharBufferWriter();
        this.decorate(decoratorName, content, out);
        CharBuffer decorated = out.toCharBuffer();
        Content lastContent = this.currentContent;
        this.currentContent = content;
        try {
            Content content2 = this.contentProcessor.build(decorated, this);
            return content2;
        }
        finally {
            this.currentContent = lastContent;
        }
    }

    public Content getContentToMerge() {
        return this.currentContent;
    }
}

